package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.dto.PrizeConfigDTO;
import com.bxm.localnews.admin.param.PrizeConfigParam;
import com.bxm.localnews.admin.service.activity.PrizeConfigService;
import com.bxm.localnews.admin.vo.PrizeConfig;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhaoyadong 2019/3/4 19:10
 * @desc
 */
@Api(tags = "1-34 [管理]奖项配置管理", description = "奖项配置管理的相关操作")
@RestController
@RequestMapping("api/admin/prize/config")
public class PrizeConfigController {

    @Autowired
    private PrizeConfigService prizeConfigService;

    @ApiOperation(value = "1-34-1 获取奖项列表", notes = "根据输入参数获取对应的奖项数据")
    @GetMapping("/list")
    public Json<PageWarper<PrizeConfig>> getPrizeConfigList(PrizeConfigParam prizeConfigParam) {
        return ResultUtil.genSuccessResult(this.prizeConfigService.queryPrizeConfig(prizeConfigParam));
    }

    @ApiOperation(value = "1-34-2 获取奖项详情", notes = "")
    @GetMapping("/detail")
    public Json<PrizeConfig> getPrizeConfig() {
        return ResultUtil.genSuccessResult(this.prizeConfigService.selectByPrimaryKey());
    }

    @ApiOperation(value = "1-34-3 新增或编辑奖项配置", notes = "")
    @PostMapping("/saveOrUpdatePrizeConfig")
    public Json<PrizeConfigDTO> addOrUpdatePrizeConfig(PrizeConfig prizeConfig) {
        if (this.prizeConfigService.saveOrUpdatePrizeConfig(prizeConfig) > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }

    @ApiOperation(value = "1-34-4 根据ID移除奖项信息")
    @ApiImplicitParam(name = "id", value = "奖项ID", required = true)
    @PostMapping("/deletePointMall")
    public Json remove(long id) {
        this.prizeConfigService.remove(id);
        return ResultUtil.genSuccessMsg("删除成功");
    }
}
