package com.bxm.localnews.admin.controller.activity;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.dto.RedPacketDTO;
import com.bxm.localnews.admin.param.RedPacketParam;
import com.bxm.localnews.admin.service.activity.RedPacketService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "1-45 [管理]口令红包相关接口", description = "红包相关接口")
@RestController
@RequestMapping("api/admin/packet")
public class RedPacketController {

    /**
     * 日志对象
     */
    private static final Logger LOG = LoggerFactory.getLogger(RedPacketController.class);

    /**
     * 红包相关服务
     */
    private RedPacketService redPacketService;

    /**
     * 参数注入
     */
    @Autowired
    public RedPacketController(RedPacketService redPacketService) {
        this.redPacketService = redPacketService;
    }

    @ApiOperation(value = "1-45-01 获取红包列表", notes = "获取红包列表")
    @PostMapping("/list")
    public Json<PageWarper<RedPacketDTO>> getRedPacketList(@RequestBody RedPacketParam redPacketParam) {
        return ResultUtil.genSuccessResult(redPacketService.queryList(redPacketParam));
    }

    @ApiOperation(value = "1-45-02 审核红包", notes = "审核红包")
    @ApiImplicitParams({@ApiImplicitParam(name = "id", value = "红包id", required = true),
            @ApiImplicitParam(name = "approvalStatus", value = "审核状态,1：拒绝，2：通过", required = true),
            @ApiImplicitParam(name = "approvalContent", value = "审核内容", required = true)})
    @PostMapping("/approval")
    public Json approvalRedPacket(Long id, Integer approvalStatus, String approvalContent) {
        if (! redPacketService.approvalRedPacket(id, approvalStatus, approvalContent)) {
            LOG.error("审核红包失败,红包id:{],审核状态:{}", id, approvalStatus);
            return ResultUtil.genFailedResult("审核红包失败");
        }
        return ResultUtil.genSuccessResult("审核红包成功");
    }

    @ApiOperation(value = "1-45-03 修改上下线状态", notes = "修改上下线状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "红包id", required = true),
            @ApiImplicitParam(name = "onlineStatus", value = "上下线状态", required = true)
    })
    @PostMapping("/status/update")
    public Json updateOnlineStatus(Long id, Integer onlineStatus) {
        if (!redPacketService.updateOnlineStatus(id, onlineStatus)) {
            LOG.error("修改红包上下线失败,红包id:{],上下线状态:{}", id, onlineStatus);
            return ResultUtil.genFailedResult("修改红包上下线失败");
        }

        return ResultUtil.genSuccessResult("修改上下线状态成功");
    }

    @ApiOperation(value = "1-45-04 获取红包详情", notes = "获取红包详情")
    @ApiImplicitParam(name = "id", value = "红包id", required = true)
    @PostMapping("/detail")
    public Json<RedPacketDTO> getDetail(Long id) {

        RedPacketDTO redPacketDTO = redPacketService.getRedPacketDetail(id);
        if (null == redPacketDTO) {
            return ResultUtil.genFailedResult("获取详情为空");
        }
        return ResultUtil.genSuccessResult(redPacketDTO);
    }

    @ApiOperation(value = "1-45-05 编辑红包", notes = "编辑红包")
    @PostMapping("/edit")
    public Json editRedPacket(@RequestBody RedPacketParam redPacketParam) {

        if (!redPacketService.editRedPacket(redPacketParam)) {
            LOG.error("编辑红包失败,编辑的参数为:{}", JSON.toJSONString(redPacketParam));
            return ResultUtil.genFailedResult("编辑红包失败");
        }
        return ResultUtil.genSuccessResult("编辑红包成功");
    }

}
