package com.bxm.localnews.admin.controller.base;

import java.util.List;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminVirtualUserDTO;
import com.bxm.localnews.admin.dto.ChatVirtualUserDTO;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.param.VirtualUserParam;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-54 [管理]马甲号管理", description = "马甲号的相关操作")
@RestController
@RequestMapping("api/admin/vest")
public class AdminVestController extends CommonController {

    @Autowired
    private VirtualUserService virtualUserService;

    @ApiOperation(value = "1-54-1 获取马甲号列表", notes = "根据输入参数获取对应的马甲号数据")
    @GetMapping("/list")
    public Json<PageWarper<AdminVirtualUserDTO>> listVirtualUser(VirtualUserParam virtualUserParam) {
        return ResultUtil.genSuccessResult(virtualUserService.listByPage(virtualUserParam));
    }

    @ApiOperation(value = "1-54-2 获取马甲号详情", notes = "获取马甲号详情")
    @GetMapping("/detail")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "马甲号id（用户id）", required = true)
    })
    public Json<VirtualUser> getVirtualUserDetail(Long id) {
        return ResultUtil.genSuccessResult(virtualUserService.getVirtualUserDetail(id));
    }

    @ApiOperation(value = "1-54-3 新增或编辑马甲号", notes = "新增或编辑马甲号")
    @PostMapping("saveOrUpdate")
    public Json addAdvertDetail(@RequestBody VirtualUserInfoParam virtualUserInfoParam) {
        return ResultUtil.genSuccessResult(virtualUserService.save(virtualUserInfoParam));
    }

    @ApiOperation(value = "1-54-4 删除马甲号(暂无)", notes = "删除马甲号")
    @PostMapping("delete")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "马甲号id（用户id）", required = true)
    })
    public Json delete(Long id) {
        return ResultUtil.genFailedResult("删除成功");
    }

    @ApiOperation(value = "1-54-5 根据类型获取马甲号", notes = "根据类型获取马甲号（在[发帖]或者[回复评论]时，需调此接口获得马甲号列表以供选择）")
    @GetMapping("listCondition")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "type", value = "类型 1:评论马甲 2:发帖马甲 不传则查全部", required = false),
            @ApiImplicitParam(name = "nickname", value = "昵称", required = false),
            @ApiImplicitParam(name = "remark", value = "备注", required = false)
    })
    public Json<List<VirtualUserOverviewDTO>> listVirtualUserByType(VirtualUserQueryParam virtualUserQueryParam) {
        return ResultUtil.genSuccessResult(virtualUserService.list(virtualUserQueryParam));
    }

    @ApiOperation(value = "1-54-6 更换马甲号管控账号", notes = "更换马甲号的管控账号")
    @GetMapping("controlAccount")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "virtualUserId", value = "马甲号id"),
            @ApiImplicitParam(name = "adminUserId", value = "昵称"),
    })
    public Json controlAccount(@RequestParam Long virtualUserId ,@RequestParam Long adminUserId) {
        AdminUser loginUser = getLoginUser();
        virtualUserService.changeVestControl(virtualUserId,adminUserId,loginUser);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "1-54-7 获取运营账号下管控的马甲号", notes = "获取运营管控马甲号列表")
    @GetMapping("virtual/list")
    public Json<List<ChatVirtualUserDTO>> virtuaList() {
        AdminUser loginUser = getLoginUser();
        List<ChatVirtualUserDTO> list = virtualUserService.getVirtualList(loginUser);
        return ResultUtil.genSuccessResult(list);
    }

    @ApiOperation(value = "1-54-8 根据用户名或id模糊查询真实用户", notes = "用户id或昵称搜索用户列表")
    @GetMapping("real/user")
    @ApiImplicitParam(name = "keyWord", value = "昵称")
    public Json<List<User>> realUserList(@RequestParam String keyWord) {
        List<User> result = virtualUserService.getUserByKeyWord(keyWord);
        return ResultUtil.genSuccessResult(result);
    }

}
