package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.UserFeedBackDTO;
import com.bxm.localnews.admin.param.FeedbackParam;
import com.bxm.localnews.admin.service.base.UserFeedbackService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("api/admin/feedback")
@Api(tags = "1-37 用户反馈管理", description = "用户反馈管理")
public class UserFeedbackController {
	private UserFeedbackService userFeedbackService;

	@Autowired
	public UserFeedbackController(UserFeedbackService userFeedbackService){
		this.userFeedbackService = userFeedbackService;
	}

	@ApiOperation(value = "1-37-1 用户反馈管理列表", notes = "用户反馈管理列表")
	@GetMapping("/list")
	public Json<PageWarper<UserFeedBackDTO>> listFeedBack(FeedbackParam feedbackParam){
		return ResultUtil.genSuccessResult(userFeedbackService.listFeedBack(feedbackParam));
	}

}
