package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.service.base.CommonDictService;
import com.bxm.localnews.admin.vo.CommonDict;
import com.bxm.localnews.common.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "1-59 [管理]行业列表", description = "用户标签")
@RestController
@RequestMapping("api/admin/userJobTag")
public class UserJobTagController {

    @Autowired
    private CommonDictService commonDictService;

    @ApiOperation(value = "1-59-1 行业列表查询", notes = "行业列表查询，parentId传0则查询一级行业")
    @ApiImplicitParam(name = "parentId", value = "行业列表父级id,一级传0", required = true)
    @GetMapping("/{parentId}")
    public Json<List<CommonDict>> listTags(@PathVariable Long parentId) {
        return Json.ok(commonDictService.listJobByParentId(parentId));
    }
}
