package com.bxm.localnews.admin.controller.editor;

import com.bxm.localnews.admin.param.EditorMessageParam;
import com.bxm.localnews.admin.service.editor.EditorMessageService;
import com.bxm.localnews.admin.vo.BasicEditorMessage;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageParam;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "1-53 [管理]编辑寄语管理", description = "编辑寄语相关接口")
@RestController
@RequestMapping("api/admin/editMessage")
public class EditorMessageController {

	private final EditorMessageService editorMessageService;

	@Autowired
	public EditorMessageController(EditorMessageService editorMessageService){
		this.editorMessageService = editorMessageService;
	}

	@ApiOperation(value = "1-53-1 编辑寄语新增或修改", notes = "编辑寄语新增或修改")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "userId", value = "用户id", required = true),
			@ApiImplicitParam(name = "id", value = "模板id,新增时传0或者 null", required = true),
			@ApiImplicitParam(name = "content", value = "寄语内容", required = true),
			@ApiImplicitParam(name = "templateName", value = "寄语名称", required = true),
	})
	@PostMapping("saveOrUpdate")
	public Json saveOrUpdateEditorMessage(EditorMessageParam editorMessageParam) {
		int result = editorMessageService.doSaveOrUpdateEditorMessage(editorMessageParam);
		if (result > 0){
			return ResultUtil.genSuccessResult("保存成功!");
		}
		return ResultUtil.genFailedResult("保存失败");
	}

	@ApiOperation(value = "1-53-2 分页展示编辑寄语列表 ", notes = " 分页展示编辑寄语列表")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNum", value = "当前是第几页", required = true),
			@ApiImplicitParam(name = "pageSize", value = "每页显示数量", required = true)
	})
	@GetMapping("listAll")
	public Json<PageWarper<BasicEditorMessage>>  listAll(PageParam pageParam) {
		PageWarper<BasicEditorMessage> result = editorMessageService.listPage(pageParam);
		return ResultUtil.genSuccessResult(result);
	}

	@ApiOperation(value = "1-53-3 根据id删除编辑寄语", notes = "删除编辑寄语")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id", value = "模板id", required = true)
	})
	@PostMapping("deleteById")
	public Json  deleteById(Long id) {
		int result = editorMessageService.deleteById(id);
		if (result > 0){
			return ResultUtil.genSuccessResult("删除成功!");
		}
		return ResultUtil.genFailedResult("删除失败");
	}


	@ApiOperation(value = "1-53-4 获得编辑寄语列表不分页", notes = "编辑寄语列表")
	@GetMapping("getAll")
	public Json<List<BasicEditorMessage>>  getAll() {
		List<BasicEditorMessage> result = editorMessageService.listAll();
		return ResultUtil.genSuccessResult(result);
	}



}
