package com.bxm.localnews.admin.controller.im;

import com.bxm.localnews.admin.param.CreateTimingRedPacketPlanParam;
import com.bxm.localnews.admin.param.IdParam;
import com.bxm.localnews.admin.param.ListPlansByChatRoomIdParam;
import com.bxm.localnews.admin.param.UpdateTimingRedPacketPlanParam;
import com.bxm.localnews.admin.service.im.ImChatRoomRedPacketService;
import com.bxm.localnews.admin.vo.im.ImTimingRedPacketPlanVO;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Gonzo
 * @date 2019-11-01 10:22
 */
@Api(tags = "1-60 聊天室定时红包相关接口")
@RestController
@RequestMapping("api/im/chatRoom/timingRedPacket")
public class ImChatRoomRedPacketController {

    @Autowired
    private ImChatRoomRedPacketService imChatRoomRedPacketService;

    @ApiOperation(value = "1-60-1 根据聊天室id查询所有定时红包计划", notes = "")
    @GetMapping("plans")
    public Json<PageWarper<ImTimingRedPacketPlanVO>> listPlansByChatRoomId(@Validated ListPlansByChatRoomIdParam param) {
        return Json.ok(imChatRoomRedPacketService.listPlansByChatRoomId(param));
    }


    @ApiOperation(value = "1-60-2 创建聊天室定时红包计划", notes = "")
    @PostMapping("plans/create")
    public Json createTimingRedPacketPlan(@RequestBody @Validated CreateTimingRedPacketPlanParam param) {
        return imChatRoomRedPacketService.createTimingRedPacketPlan(param);
    }

    @ApiOperation(value = "1-60-3 编辑聊天室定时红包计划", notes = "")
    @PostMapping("plans/update")
    public Json updateTimingRedPacketPlan(@RequestBody @Validated UpdateTimingRedPacketPlanParam param) {
        return imChatRoomRedPacketService.updateTimingRedPacketPlan(param);
    }

    @ApiOperation(value = "1-60-4 删除聊天室定时红包计划", notes = "")
    @PostMapping("plans/delete")
    public Json deleteTimingRedPacketPlan(@RequestBody @Validated IdParam param) {
        return imChatRoomRedPacketService.deleteTimingRedPacketPlan(param);
    }

}
