package com.bxm.localnews.admin.controller.market;

import com.bxm.localnews.admin.param.GoldFlowQueryParam;
import com.bxm.localnews.admin.service.market.GoldFlowService;
import com.bxm.localnews.admin.vo.GoldFlow;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

@Api(tags = "1-52 [管理]金币流水管理", description = "金币流水管理")
@RestController
@RequestMapping("api/admin/goldFlow")
public class GoldFlowController extends BaseController {

    @Resource
    private GoldFlowService goldFlowService;

    @ApiOperation(value = "1-52-1 流水类型查询")
    @GetMapping("getTypeList")
    public Json<List<String>> getTypeList() {
        return ResultUtil.genSuccessResult(goldFlowService.getTypeList());
    }

    @ApiOperation(value = "1-52-2 获取流水列表")
    @GetMapping("list")
    public Json<PageWarper<GoldFlow>> getList(GoldFlowQueryParam param) {
        return ResultUtil.genSuccessResult(goldFlowService.getList(param));
    }

    @ApiOperation(value = "1-52-3 流水列表导出")
    @GetMapping("exportExcel")
    public void exportExcel(GoldFlowQueryParam param, HttpServletResponse response) {
        goldFlowService.exportExcel(param, response);
    }
}

