package com.bxm.localnews.admin.controller.market;

import com.bxm.localnews.admin.param.MarketOrderQueryParam;
import com.bxm.localnews.admin.service.market.MarketOrderService;
import com.bxm.localnews.admin.vo.MarketOrder;
import com.bxm.localnews.admin.vo.MarketOrderExpressage;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

@Api(tags = "1-51 [管理]订单管理", description = "积分商城订单管理")
@RestController
@RequestMapping("api/admin/marketOrder")
public class MarketOrderController extends BaseController {

    @Resource
    private MarketOrderService marketOrderService;

    @ApiOperation(value = "1-51-1 获取订单列表")
    @GetMapping("list")
    public Json<PageWarper<MarketOrder>> getList(MarketOrderQueryParam param) {
        return ResultUtil.genSuccessResult(marketOrderService.getList(param));
    }

    @ApiOperation(value = "1-51-2 新增或编辑物流信息")
    @PostMapping("saveOrUpdate")
    public Json saveOrUpdate(@RequestBody MarketOrderExpressage marketOrderExpressage) {
        return ResultUtil.genSuccessResult(marketOrderService.saveOrUpdate(marketOrderExpressage));
    }

    @ApiOperation(value = "1-51-3 订单列表导出")
    @GetMapping("exportExcel")
    public void exportExcel(MarketOrderQueryParam param, HttpServletResponse response) {
        marketOrderService.exportExcel(param, response);
    }
}

