package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.dto.ReplyDTO;
import com.bxm.localnews.admin.dto.ReplyDetailDTO;
import com.bxm.localnews.admin.integration.NewsIntegrationService;
import com.bxm.localnews.admin.param.AllReplyParam;
import com.bxm.localnews.admin.param.CommentReplyParam;
import com.bxm.localnews.admin.param.NewsReplyOriginalParam;
import com.bxm.localnews.admin.param.NewsReplyParam;
import com.bxm.localnews.admin.service.news.AdminNewsReplyService;
import com.bxm.localnews.admin.vo.NewsReply;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@Api(tags = "1-35 [管理]新闻管理中评论管理", description = "新闻评论管理，包括新闻评论的模拟生成，添加，删除")
@RestController
@RequestMapping("api/admin/news/reply")
public class AdminNewsReplyController {

    @Autowired
    private AdminNewsReplyService adminNewsReplyService;
    @Autowired
    private NewsIntegrationService newsIntegrationService;

    @ApiOperation("1-35-1 模拟评论生成")
    @PostMapping("/virtual")
    public Json generate(@RequestBody NewsReplyOriginalParam newsReplyOriginalParam) {
        if (newsReplyOriginalParam.getNewsId() != null) {
            this.adminNewsReplyService.doGenerateReply(newsReplyOriginalParam);
            //扫描待展示的评论,
            //newsIntegrationService.updateNewsReplyStatus();
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

    @ApiOperation("1-35-2 新闻下评论分页")
    @GetMapping("/list")
    public Json<PageWarper<NewsReply>> queryPage(NewsReplyParam newsReplyParam) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.listNewsReply(newsReplyParam));
    }

    @ApiOperation("1-35-3 评论删除")
    @PostMapping("/del")
    public Json del(@RequestParam Long replyId,@RequestParam Long newsId) {
        if (newsId != null) {
            this.adminNewsReplyService.delReply(replyId,newsId);
            return ResultUtil.genSuccessResult();
        } else {
            return ResultUtil.genFailedResult("请输入新闻编号");
        }
    }

    @ApiOperation("1-35-4 增加评论回复")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "parentReplyId", value = "上级评论id", required = true),
            @ApiImplicitParam(name = "replyContent", value = "评论内容", required = true),
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true),
            @ApiImplicitParam(name = "virtualUserId", value = "马甲号用户id", required = true),
            @ApiImplicitParam(name = "virtualHeadImg", value = "马甲号用户头像", required = true),
            @ApiImplicitParam(name = "virtualNickName", value = "马甲号用户昵称", required = true),
            @ApiImplicitParam(name = "replyTime", value = "评论回复时间", required = true),

    })
    @PostMapping("/addCommentReply")
    public Json addCommentReply(CommentReplyParam commentReplyParam) {
        int result = adminNewsReplyService.doAddCommentReply(commentReplyParam);
//        if (result > 0){
//            Date currentTime = new Date();
//            //展示时间是否小于当前时间调用新闻扫描评论的接口
//            if (currentTime.compareTo(commentReplyParam.getReplyTime()) >= 0){
//                newsIntegrationService.updateNewsReplyStatus();
//            }
//            return ResultUtil.genSuccessResult("添加评论成功!");
//        }
        return ResultUtil.genSuccessMsg("添加评论成功");

    }


    @ApiOperation("1-35-5 评论分页")
    @GetMapping("/allList")
    public Json<PageWarper<ReplyDTO>> queryAllList(AllReplyParam allReplyParam) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.listAllNewsReply(allReplyParam));
    }

    @ApiOperation("1-35-6 评论详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true),
            @ApiImplicitParam(name = "replyId", value = "评论id", required = true),
    })
    @GetMapping("/getReplyDetail")
    public Json<ReplyDetailDTO> getReplyDetail(Long newsId,Long replyId) {
        return ResultUtil.genSuccessResult(adminNewsReplyService.getReplyDetail(newsId,replyId));
    }

}

