package com.bxm.localnews.admin.controller.news;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminPushMessageDTO;
import com.bxm.localnews.admin.dto.PushMessageStatistical;
import com.bxm.localnews.admin.param.PushMessageParam;
import com.bxm.localnews.admin.service.activity.AdminPushMessageService;
import com.bxm.localnews.admin.vo.AdminPushMessage;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author zhaoyadong 2019/1/16 15:50
 * @desc
 */
@Api(tags = "1-27 消息推送相关接口", description = "")
@RestController
@RequestMapping("/api/admin/push/message")
public class AdminPushMessageController extends CommonController {

    private AdminPushMessageService adminPushMessageService;

    @Autowired
    public AdminPushMessageController(AdminPushMessageService adminPushMessageService) {
        this.adminPushMessageService = adminPushMessageService;
    }

    @ApiOperation(value = "1-27-1 获取消息记录列表", notes = "根据输入参数获取对应的消息数据")
    @GetMapping("/list")
    public Json<PageWarper<AdminPushMessageDTO>> getPushMessageList(PushMessageParam pushMessageParam) {
        return ResultUtil.genSuccessResult(this.adminPushMessageService.queryPushMessageList(pushMessageParam));
    }

    @ApiOperation(value = "1-27-2 推送消息批量修改状态", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id字符串，以”,“分隔", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("/batchUpdatePushMessage")
    public Json updatePushMessageStatusByIds(String ids, Byte status) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String id[] = idsNew.split(",");
        if (id.length > 0) {
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择新闻");
        }
    }

    @ApiOperation(value = "1-27-3 获取推送消息详情", notes = "")
    @ApiImplicitParam(name = "id", value = "活动id", required = true)
    @GetMapping("/getPushMessageDetail")
    public Json<AdminPushMessage> getActivityDetail(Long id) {
        return ResultUtil.genSuccessResult(this.adminPushMessageService.getDetail(id));
    }

    @ApiOperation(value = "1-27-4 消息修改状态(取消推送)", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("/updatePushMessage")
    public Json updatePushMessageStatusById(Long id, Byte status) {
        return ResultUtil.genSuccessResult(this.adminPushMessageService.updateStatusPushMessage(id, status).getLashMessaage());
    }

    @ApiOperation(value = "1-27-5 新增或编辑消息", notes = "")
    @PostMapping("/saveOrUpdatePushMessage")
    public Json addPushMessageDetail(AdminPushMessage adminPushMessage) {
        if (adminPushMessage.getId() == null) {
            adminPushMessage.setCreateUserId(getLoginUser().getId());
        }
        Message message = this.adminPushMessageService.saveOrUpdatePushMessage(adminPushMessage);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult(message.getLashMessaage());
        }
        return ResultUtil.genSuccessMsg("操作成功");
    }


    @ApiOperation(value = "1-27-6 对应消息的统计信息", notes = "")
    @ApiImplicitParam(name = "messageId", value = "消息id", required = true)
    @GetMapping("/statistics")
    public Json<List<PushMessageStatistical>> statisticsMessage(Long messageId) {
        return ResultUtil.genSuccessResult(this.adminPushMessageService.getStatistical(messageId));
    }


    @ApiOperation(value = "1-27-7 消息推送测试", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "消息id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @PostMapping("/test")
    public Json testPushMessage(Long id, Long userId) {
        return ResultUtil.genSuccessResult(this.adminPushMessageService.testPushMessage(id, userId));
    }

    @ApiOperation(value = "1-27-8 消息推送", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true)
    })
    @PostMapping("/immediate")
    public Json immediatelyPushMessage(Long id) {
        return ResultUtil.genSuccessResult(this.adminPushMessageService.immediatelyPushMessage(id));
    }

    @ApiOperation(value = "1-27-9 消息批量用户推送测试", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "消息id", required = true),
            @ApiImplicitParam(name = "userIds", value = "用户id组, 以','分隔", required = true)
    })
    @PostMapping("/batch/test")
    public Json batchTestPushMessage(Long id, String userIds) {
        return ResultUtil.genSuccessResult(this.adminPushMessageService.testPushMessage(id, userIds));
    }
}
