/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.param.PrivilegeParam;
import com.bxm.localnews.admin.param.PrivilegeQueryParam;
import com.bxm.localnews.admin.service.activity.PrivilegeService;
import com.bxm.localnews.admin.vo.PrivilegeBean;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-18 [\u7ba1\u7406]\u4f18\u60e0\u6d3b\u52a8\u7ba1\u7406"}, description="\u5bf9\u4f18\u60e0\u6d3b\u52a8\u8fdb\u884c\u76f8\u5173\u7ba1\u7406\uff0c\u5305\u62ec\u589e\u5220\u67e5\u6539\uff0c\u72b6\u6001\u53d8\u66f4\u548c\u7b56\u7565\u8c03\u6574")
@RestController
@RequestMapping(value={"/api/admin/privilege"})
public class AdminPrivilegeController
extends CommonController {
    private PrivilegeService privilegeService;

    @Autowired
    public AdminPrivilegeController(PrivilegeService privilegeService) {
        this.privilegeService = privilegeService;
    }

    @ApiOperation(value="1-18-1 \u65b0\u589e\u4f18\u60e0\u6d3b\u52a8\u4fe1\u606f", notes="\u65b0\u589e\u6d3b\u52a8\u65f6ID\u4e0d\u9700\u8981\u4f20\u9012")
    @PostMapping(value={"save"})
    public Json save(PrivilegeParam param) {
        if (param.getGlobalFlag() == 1 && !StringUtils.isEmpty((Object)param.getAreaCodes())) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u6295\u653e\u533a\u57df\u9519\u8bef");
        }
        if (param.getGlobalFlag() == 0 && StringUtils.isEmpty((Object)param.getAreaCodes())) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u6295\u653e\u533a\u57df\u9519\u8bef");
        }
        return Json.build((Message)this.privilegeService.save(param));
    }

    @ApiOperation(value="1-18-2 \u7f16\u8f91\u4f18\u60e0\u6d3b\u52a8\u4fe1\u606f", notes="\u7f16\u8f91\u6d3b\u52a8\u65f6ID\u5fc5\u987b\u4f20\u9012")
    @PostMapping(value={"modify"})
    public Json modify(PrivilegeParam param) {
        return Json.build((Message)this.privilegeService.modify(param));
    }

    @ApiOperation(value="1-18-3 \u4fee\u6539\u6d3b\u52a8\u72b6\u6001", notes="\u8bbe\u7f6e\u6d3b\u52a8\u72b6\u6001\u4e3a\u542f\u7528\u6216\u7981\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d3b\u52a8ID"), @ApiImplicitParam(name="enable", value="\u6d3b\u52a8\u662f\u5426\u53ef\u7528,0\uff1a\u6682\u505c\uff0c1\uff1a\u5f00\u542f")})
    @PostMapping(value={"change/{id}/{enable}"})
    public Json change(@PathVariable long id, @PathVariable int enable) {
        return Json.build((Message)this.privilegeService.changeEnable(id, enable));
    }

    @ApiOperation(value="1-18-4 \u5206\u9875\u83b7\u53d6\u6d3b\u52a8\u5217\u8868")
    @GetMapping(value={"privileges"})
    public Json<PageWarper<PrivilegeBean>> getPrivileges(PrivilegeQueryParam param) {
        return Json.build((Object)this.privilegeService.queryByPage(param));
    }

    @ApiOperation(value="1-18-5 \u6839\u636e\u6d3b\u52a8ID\u83b7\u53d6\u6d3b\u52a8\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u6d3b\u52a8ID", required=true)
    @GetMapping(value={"{id}"})
    public Json<PrivilegeBean> getPrivilege(@PathVariable long id) {
        return Json.build((Object)this.privilegeService.get(id));
    }

    @ApiOperation(value="1-18-6 \u79fb\u9664\u6d3b\u52a8", notes="\u53ea\u80fd\u79fb\u9664\u5904\u4e8e\u7981\u7528\u72b6\u6001\u7684\u6d3b\u52a8")
    @ApiImplicitParam(name="id", value="\u6d3b\u52a8ID", required=true)
    @PostMapping(value={"remove/{id}"})
    public Json remove(@PathVariable long id) {
        return Json.build((Message)this.privilegeService.remove(id));
    }

    @ApiOperation(value="1-18-7 \u6743\u91cd\u53d8\u66f4", notes="\u53d8\u66f4\u6d3b\u52a8\u6743\u91cd\uff0c\u5f71\u54cd\u6392\u540d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6d3b\u52a8ID"), @ApiImplicitParam(name="order", value="\u6d3b\u52a8\u6392\u5e8f\uff0c\u6570\u503c\u8d8a\u5927\uff0c\u663e\u793a\u8d8a\u9760\u524d")})
    @PostMapping(value={"order/{id}/{order}"})
    public Json changeOrder(@PathVariable long id, @PathVariable int order) {
        return Json.build((Message)this.privilegeService.changeOrder(id, order));
    }

    private Json checkPrivilegeTime(PrivilegeParam param) {
        Date startTime = param.getStartTime();
        Date endTime = param.getEndTime();
        long currentTime = System.currentTimeMillis();
        if (currentTime + 120000L >= startTime.getTime()) {
            this.logger.error("\u6d3b\u52a8\u65f6\u95f4\u9519\u8bef:" + startTime.toString() + ":" + endTime.toString());
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5728\u5f53\u524d\u65f6\u95f42\u5206\u949f\u540e");
        }
        long proccessingTime = endTime.getTime() - startTime.getTime();
        if (proccessingTime < 600000L) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5728\u5f00\u59cb\u65f6\u95f4\u4e4b\u540e10\u5206\u949f");
        }
        return null;
    }
}

