/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.activity;

import com.bxm.localnews.admin.config.BizConfigProperties;
import com.bxm.localnews.admin.dto.CodeTemplate;
import com.bxm.localnews.admin.param.PushCodeParam;
import com.bxm.localnews.admin.service.activity.OfflinePushCodeService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-43 [\u7ba1\u7406]\u7ebf\u4e0b\u5730\u63a8\u7801\u751f\u6210"}, description="\u7ebf\u4e0b\u63a8\u5e7f\u751f\u6210\u5bf9\u5e94\u5730\u533a\u7684\u4e8c\u7ef4\u7801")
@RestController
@RequestMapping(value={"api/admin/push/code"})
@RefreshScope
public class OfflinePushCodeController {
    private static final Logger log = LoggerFactory.getLogger(OfflinePushCodeController.class);
    @Autowired
    private OfflinePushCodeService offlinePushCodeService;
    @Autowired
    private BizConfigProperties bizConfigProperties;

    @ApiOperation(value="1-43-01 \u751f\u6210\u7ebf\u4e0b\u5730\u63a8\u7801", notes="\u6839\u636e\u6a21\u677f\u7c7b\u578b\u751f\u6210\u5bf9\u5e94\u7684\u7ebf\u4e0b\u5730\u63a8\u7801")
    @GetMapping
    public void generatePushCode(PushCodeParam pushCodeParam, HttpServletResponse response) {
        byte[] data = this.offlinePushCodeService.generatePushCode(pushCodeParam);
        try {
            int len;
            String zipName = ((DateFormat)DateUtils.DATE_TIME_SECOND_FORMAT_THREAD_LOCAL.get()).format(new Date()) + ".zip";
            response.setContentType("application/octet-stream;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + new String(zipName.getBytes("GB2312"), "ISO-8859-1"));
            ServletOutputStream outputStream = response.getOutputStream();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            byte[] buf = new byte[1024];
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.flush();
            outputStream.close();
            this.deleteTempDir();
        }
        catch (IOException e) {
            log.error("zip\u5305\u8f93\u51fa\u5230\u5ba2\u6237\u7aef\u5f02\u5e38:", (Throwable)e);
        }
    }

    @ApiOperation(value="1-43-02 \u83b7\u53d6\u7ebf\u4e0b\u5730\u63a8\u7801\u6a21\u677f", notes="\u8fd4\u56de\u6a21\u677f\u5217\u8868")
    @GetMapping(value={"/template"})
    public Json<List<CodeTemplate>> getCodeTemplate() {
        return ResultUtil.genSuccessResult((Object)this.offlinePushCodeService.getCodeTemplates());
    }

    @ApiOperation(value="1-43-03 \u7ed1\u5b9a\u7ebf\u4e0b\u63a8\u5e7f\u7801", notes="\u7528\u6237\u7ed1\u5b9a\u7ebf\u4e0b\u63a8\u5e7f\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="remark", value="\u5907\u6ce8"), @ApiImplicitParam(name="code", value="\u63a8\u5e7f\u7801", required=true), @ApiImplicitParam(name="association", value="0: \u5426 1\uff1a\u662f", required=true)})
    @PostMapping(value={"/bind"})
    public Json<Boolean> bindPushCode(@RequestParam(value="userId") Long userId, @RequestParam(value="code") Long code, @RequestParam(value="association") Byte association, @RequestParam(value="remark", required=false) String remark) {
        if (!this.offlinePushCodeService.userIsExist(userId).booleanValue()) {
            return ResultUtil.genFailedResult((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Message message = this.offlinePushCodeService.bindPushCode(userId, association, remark, code);
        return ResultUtil.genSuccessResult((Object)message.isSuccess());
    }

    @ApiOperation(value="1-43-04 \u67e5\u770b\u7528\u6237\u662f\u5426\u5b58\u5728", notes="\u7ed1\u5b9a\u5730\u63a8\u7801\u7684\u65f6\u5019\u5224\u65ad\u7528\u6237\u662f\u5426\u5b58\u5728")
    @GetMapping(value={"/exist"})
    public Json<String> userIsExist(Long userId) {
        return ResultUtil.genSuccessResult((Object)this.offlinePushCodeService.getUserNickname(userId));
    }

    private void deleteTempDir() throws IOException {
        File dirFile = new File(this.bizConfigProperties.getTempDir());
        FileUtils.deleteDirectory((File)dirFile);
    }
}

