/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminVirtualUserDTO;
import com.bxm.localnews.admin.dto.ChatVirtualUserDTO;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.param.VirtualUserInfoParam;
import com.bxm.localnews.admin.param.VirtualUserParam;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.VirtualUser;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-54 [\u7ba1\u7406]\u9a6c\u7532\u53f7\u7ba1\u7406"}, description="\u9a6c\u7532\u53f7\u7684\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/vest"})
public class AdminVestController
extends CommonController {
    @Autowired
    private VirtualUserService virtualUserService;

    @ApiOperation(value="1-54-1 \u83b7\u53d6\u9a6c\u7532\u53f7\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u9a6c\u7532\u53f7\u6570\u636e")
    @GetMapping(value={"/list"})
    public Json<PageWarper<AdminVirtualUserDTO>> listVirtualUser(VirtualUserParam virtualUserParam) {
        return ResultUtil.genSuccessResult((Object)this.virtualUserService.listByPage(virtualUserParam));
    }

    @ApiOperation(value="1-54-2 \u83b7\u53d6\u9a6c\u7532\u53f7\u8be6\u60c5", notes="\u83b7\u53d6\u9a6c\u7532\u53f7\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9a6c\u7532\u53f7id\uff08\u7528\u6237id\uff09", required=true)})
    public Json<VirtualUser> getVirtualUserDetail(Long id) {
        return ResultUtil.genSuccessResult((Object)this.virtualUserService.getVirtualUserDetail(id));
    }

    @ApiOperation(value="1-54-3 \u65b0\u589e\u6216\u7f16\u8f91\u9a6c\u7532\u53f7", notes="\u65b0\u589e\u6216\u7f16\u8f91\u9a6c\u7532\u53f7")
    @PostMapping(value={"saveOrUpdate"})
    public Json addAdvertDetail(@RequestBody VirtualUserInfoParam virtualUserInfoParam) {
        return ResultUtil.genSuccessResult((Object)this.virtualUserService.save(virtualUserInfoParam));
    }

    @ApiOperation(value="1-54-4 \u5220\u9664\u9a6c\u7532\u53f7(\u6682\u65e0)", notes="\u5220\u9664\u9a6c\u7532\u53f7")
    @PostMapping(value={"delete"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9a6c\u7532\u53f7id\uff08\u7528\u6237id\uff09", required=true)})
    public Json delete(Long id) {
        return ResultUtil.genFailedResult((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="1-54-5 \u6839\u636e\u7c7b\u578b\u83b7\u53d6\u9a6c\u7532\u53f7", notes="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u9a6c\u7532\u53f7\uff08\u5728[\u53d1\u5e16]\u6216\u8005[\u56de\u590d\u8bc4\u8bba]\u65f6\uff0c\u9700\u8c03\u6b64\u63a5\u53e3\u83b7\u5f97\u9a6c\u7532\u53f7\u5217\u8868\u4ee5\u4f9b\u9009\u62e9\uff09")
    @GetMapping(value={"listCondition"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u7c7b\u578b 1:\u8bc4\u8bba\u9a6c\u7532 2:\u53d1\u5e16\u9a6c\u7532 \u4e0d\u4f20\u5219\u67e5\u5168\u90e8", required=false), @ApiImplicitParam(name="nickname", value="\u6635\u79f0", required=false), @ApiImplicitParam(name="remark", value="\u5907\u6ce8", required=false)})
    public Json<List<VirtualUserOverviewDTO>> listVirtualUserByType(VirtualUserQueryParam virtualUserQueryParam) {
        return ResultUtil.genSuccessResult((Object)this.virtualUserService.list(virtualUserQueryParam));
    }

    @ApiOperation(value="1-54-6 \u66f4\u6362\u9a6c\u7532\u53f7\u7ba1\u63a7\u8d26\u53f7", notes="\u66f4\u6362\u9a6c\u7532\u53f7\u7684\u7ba1\u63a7\u8d26\u53f7")
    @GetMapping(value={"controlAccount"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="virtualUserId", value="\u9a6c\u7532\u53f7id"), @ApiImplicitParam(name="adminUserId", value="\u6635\u79f0")})
    public Json controlAccount(@RequestParam Long virtualUserId, @RequestParam Long adminUserId) {
        AdminUser loginUser = this.getLoginUser();
        this.virtualUserService.changeVestControl(virtualUserId, adminUserId, loginUser);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="1-54-7 \u83b7\u53d6\u8fd0\u8425\u8d26\u53f7\u4e0b\u7ba1\u63a7\u7684\u9a6c\u7532\u53f7", notes="\u83b7\u53d6\u8fd0\u8425\u7ba1\u63a7\u9a6c\u7532\u53f7\u5217\u8868")
    @GetMapping(value={"virtual/list"})
    public Json<List<ChatVirtualUserDTO>> virtuaList() {
        AdminUser loginUser = this.getLoginUser();
        List list = this.virtualUserService.getVirtualList(loginUser);
        return ResultUtil.genSuccessResult((Object)list);
    }

    @ApiOperation(value="1-54-8 \u6839\u636e\u7528\u6237\u540d\u6216id\u6a21\u7cca\u67e5\u8be2\u771f\u5b9e\u7528\u6237", notes="\u7528\u6237id\u6216\u6635\u79f0\u641c\u7d22\u7528\u6237\u5217\u8868")
    @GetMapping(value={"real/user"})
    @ApiImplicitParam(name="keyWord", value="\u6635\u79f0")
    public Json<List<User>> realUserList(@RequestParam String keyWord) {
        List result = this.virtualUserService.getUserByKeyWord(keyWord);
        return ResultUtil.genSuccessResult((Object)result);
    }
}

