/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.base;

import com.bxm.localnews.admin.dto.AdvertDeliveryObjectDTO;
import com.bxm.localnews.admin.dto.AdvertMaterialDTO;
import com.bxm.localnews.admin.dto.AdvertPositionDTO;
import com.bxm.localnews.admin.dto.AdvertTypeDTO;
import com.bxm.localnews.admin.param.AdvertMaterialParam;
import com.bxm.localnews.admin.param.AdvertPositionParam;
import com.bxm.localnews.admin.service.base.AdvertisementService;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-36 [\u7ba1\u7406]\u5e7f\u544a\u7d20\u6750\u6295\u653e\u7ba1\u7406"}, description="\u5e7f\u544a\u7d20\u6750\u6295\u653e\u7ba1\u7406")
@RestController
@RequestMapping(value={"api/admin/advertisement"})
public class AdvertController {
    private static final Logger LOG = LoggerFactory.getLogger(AdvertController.class);
    private AdvertisementService advertisementService;

    @Autowired
    public AdvertController(AdvertisementService advertisementService) {
        this.advertisementService = advertisementService;
    }

    @ApiOperation(value="1-36-1 \u5e7f\u544a\u7d20\u6750\u505c\u542f\u7528", notes="\u5e7f\u544a\u7d20\u6750\u505c\u542f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/material/status"})
    public Json updateAdvertStatusById(Long id, Integer status) {
        if (1 != this.advertisementService.updateMaterialStatus(id, status)) {
            LOG.error("\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        return ResultUtil.genSuccessResult((Object)"\u66f4\u6539\u5e7f\u544a\u7d20\u6750\u72b6\u6001\u6210\u529f");
    }

    @ApiOperation(value="1-36-2 \u65b0\u589e\u5e7f\u544a\u7d20\u6750", notes="\u65b0\u589e\u5e7f\u544a\u7d20\u6750")
    @PostMapping(value={"/material/add"})
    public Json addAdvertDetail(@RequestBody AdvertMaterialParam advertMaterialParam) {
        if (0 < this.advertisementService.addAdvertisementMaterial(advertMaterialParam)) {
            return ResultUtil.genSuccessResult((Object)"\u65b0\u589e\u6210\u529f");
        }
        LOG.error("\u65b0\u589e\u5e7f\u544a\u7d20\u6750\u5931\u8d25");
        return ResultUtil.genFailedResult((String)"\u65b0\u589e\u5931\u8d25");
    }

    @ApiOperation(value="1-36-3 \u7f16\u8f91\u5e7f\u544a\u7d20\u6750", notes="\u7f16\u8f91\u5e7f\u544a\u7d20\u6750")
    @PostMapping(value={"/material/edit"})
    public Json editAdvertDetail(@RequestBody AdvertMaterialParam advertMaterialParam) {
        if (1 != this.advertisementService.modifyAdvertisementMaterial(advertMaterialParam)) {
            LOG.error("\u66f4\u6539\u5e7f\u544a\u7d20\u6750\u5931\u8d25");
            return ResultUtil.genFailedResult((String)"\u66f4\u6539\u5e7f\u544a\u7d20\u6750\u5931\u8d25");
        }
        return ResultUtil.genSuccessResult((Object)"\u66f4\u6539\u5e7f\u544a\u7d20\u6750\u6210\u529f");
    }

    @ApiOperation(value="1-36-4 \u83b7\u53d6\u5e7f\u544a\u7d20\u6750\u8be6\u60c5", notes="\u6839\u636eid\u83b7\u53d6\u5e7f\u544a\u8be6\u60c5")
    @GetMapping(value={"/material/detail"})
    @ApiImplicitParam(name="id", value="id", required=true)
    public Json<AdvertMaterialDTO> getAdvertById(Long id) {
        AdvertMaterialDTO advertMaterialDTO = this.advertisementService.getAdvertisementMaterialInfo(id);
        if (null == advertMaterialDTO) {
            return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u5e7f\u544a\u7d20\u6750\u8be6\u60c5\u5931\u8d25");
        }
        return ResultUtil.genSuccessResult((Object)advertMaterialDTO);
    }

    @ApiOperation(value="1-36-5 \u5220\u9664\u5e7f\u544a\u7d20\u6750,\u5220\u9664\u524d\u524d\u7aef\u9700\u5148\u5224\u65ad\u7d20\u6750\u7684\u5173\u8054\u5173\u7cfb(\u63a5\u53e3)", notes="\u5220\u9664\u5e7f\u544a\u7d20\u6750,\u5220\u9664\u524d\u524d\u7aef\u9700\u5148\u5224\u65ad\u7d20\u6750\u7684\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"/material/delete"})
    @ApiImplicitParam(name="id", value="id", required=true)
    public Json deleteAdvert(Long id) {
        if (this.advertisementService.delAdvertisementMaterial(id) > 0) {
            return ResultUtil.genSuccessMsg((String)"\u5220\u9664\u6210\u529f");
        }
        return ResultUtil.genFailedResult((String)"\u5220\u9664\u5931\u8d25");
    }

    @ApiOperation(value="1-36-6 \u83b7\u53d6\u5e7f\u544a\u7d20\u6750\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u5e7f\u544a\u7d20\u6750\u5217\u8868")
    @PostMapping(value={"/material/list"})
    public Json<PageWarper<AdvertMaterialDTO>> getAdvertList(@RequestBody AdvertMaterialParam advertMaterialParam) {
        PageWarper result = this.advertisementService.queryMaterialList(advertMaterialParam);
        return ResultUtil.genSuccessResult((Object)result);
    }

    @ApiOperation(value="1-36-7 \u5e7f\u544a\u6295\u653e\u505c\u542f\u7528", notes="\u5e7f\u544a\u6295\u653e\u505c\u542f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="status", value="\u72b6\u6001", required=true)})
    @PostMapping(value={"/position/status"})
    public Json updateAdvertPositionStatusById(Long id, Integer status) {
        if (1 != this.advertisementService.updatePositionStatus(id, status)) {
            LOG.error("\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
            return ResultUtil.genFailedResult((String)"\u66f4\u65b0\u72b6\u6001\u5931\u8d25");
        }
        return ResultUtil.genSuccessResult((Object)"\u66f4\u6539\u5e7f\u544a\u6295\u653e\u72b6\u6001\u6210\u529f");
    }

    @ApiOperation(value="1-36-8 \u65b0\u589e\u5e7f\u544a\u6295\u653e", notes="\u65b0\u589e\u5e7f\u544a\u6295\u653e")
    @PostMapping(value={"/position/add"})
    public Json addAdvertPosition(@RequestBody AdvertPositionParam advertPositionParam) {
        try {
            if (!this.advertisementService.addAdvertisementPosition(advertPositionParam)) {
                return ResultUtil.genFailedResult((String)"\u65b0\u589e\u5e7f\u544a\u6295\u653e\u5931\u8d25");
            }
            return ResultUtil.genSuccessMsg((String)"\u65b0\u589e\u5e7f\u544a\u6295\u653e\u6210\u529f");
        }
        catch (Exception e) {
            LOG.error("\u65b0\u589e\u5e7f\u544a\u6295\u653e\u5f02\u5e38", (Throwable)e);
            return ResultUtil.genFailedResult((String)"\u65b0\u589e\u5e7f\u544a\u6295\u653e\u5f02\u5e38");
        }
    }

    @ApiOperation(value="1-36-9 \u7f16\u8f91\u5e7f\u544a\u6295\u653e\u4fe1\u606f", notes="\u7f16\u8f91\u5e7f\u544a\u6295\u653e\u4fe1\u606f")
    @PostMapping(value={"/position/edit"})
    public Json editAdvertPosition(@RequestBody AdvertPositionParam advertPositionParam) {
        if (!this.advertisementService.editAdvertisementPosition(advertPositionParam)) {
            return ResultUtil.genFailedResult((String)"\u7f16\u8f91\u5e7f\u544a\u6295\u653e\u4fe1\u606f\u5931\u8d25");
        }
        return ResultUtil.genSuccessMsg((String)"\u7f16\u8f91\u5e7f\u544a\u6295\u653e\u4fe1\u606f\u6210\u529f");
    }

    @ApiOperation(value="1-36-10 \u83b7\u53d6\u5e7f\u544a\u6295\u653e\u8be6\u60c5", notes="\u6839\u636eid\u83b7\u53d6\u5e7f\u544a\u6295\u653e\u8be6\u60c5")
    @GetMapping(value={"/position/detail"})
    @ApiImplicitParam(name="id", value="id", required=true)
    public Json<AdvertPositionDTO> getAdvertPositionById(Long id) {
        try {
            AdvertPositionDTO advertPositionDTO = this.advertisementService.getAdvertPositionDetail(id);
            if (null == advertPositionDTO) {
                return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u5e7f\u544a\u6295\u653e\u8be6\u60c5\u4e3a\u7a7a");
            }
            return ResultUtil.genSuccessResult((Object)advertPositionDTO);
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u5e7f\u544a\u6295\u653e\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ResultUtil.genFailedResult((String)"\u83b7\u53d6\u5e7f\u544a\u6295\u653e\u8be6\u60c5\u5f02\u5e38");
        }
    }

    @ApiOperation(value="1-36-11 \u5220\u9664\u5e7f\u544a\u6295\u653e", notes="\u5220\u9664\u5e7f\u544a\u6295\u653e")
    @PostMapping(value={"/position/delete"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true), @ApiImplicitParam(name="positionType", value="\u5e7f\u544a\u6295\u653e\u7c7b\u578b", required=true)})
    public Json deleteAdvertPosition(Long id, Integer positionType) {
        if (!this.advertisementService.delAdvertPosition(id, positionType)) {
            return ResultUtil.genFailedResult((String)"\u5220\u9664\u5931\u8d25");
        }
        return ResultUtil.genSuccessMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="1-36-12 \u83b7\u53d6\u5e7f\u544a\u6295\u653e\u5217\u8868", notes="\u6839\u636e\u8f93\u5165\u53c2\u6570\u83b7\u53d6\u5bf9\u5e94\u7684\u5e7f\u544a\u6570\u636e")
    @PostMapping(value={"/position/list"})
    public Json<PageWarper<AdvertPositionDTO>> getAdvertPositionList(@RequestBody AdvertPositionParam advertPositionParam) {
        return ResultUtil.genSuccessResult((Object)this.advertisementService.queryPositionList(advertPositionParam));
    }

    @ApiOperation(value="1-36-13 \u83b7\u53d6\u7d20\u6750\u4e0e\u6295\u653e\u7684\u5173\u8054\u5173\u7cfb", notes="\u6839\u636e\u7d20\u6750id\u83b7\u53d6\u4e0e\u6295\u653e\u7684\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"/relation"})
    @ApiImplicitParam(name="materialId", value="\u7d20\u6750id", required=true)
    public Json getAdvertPositionList(Long materialId) {
        return ResultUtil.genSuccessResult((Object)this.advertisementService.getRelationListByMaterialId(materialId));
    }

    @ApiOperation(value="1-36-14 \u83b7\u53d6\u542f\u7528\u72b6\u6001\u7684\u6240\u6709\u5e7f\u544a\u7d20\u6750", notes="\u83b7\u53d6\u542f\u7528\u72b6\u6001\u7684\u6240\u6709\u5e7f\u544a\u7d20\u6750")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u5173\u952e\u5b57")})
    @PostMapping(value={"/material/all"})
    public Json getAdvertPositionList(String key) {
        return ResultUtil.genSuccessResult((Object)this.advertisementService.getAllMaterial(key));
    }

    @ApiOperation(value="1-36-15 \u83b7\u53d6\u6240\u6709\u5e7f\u544a\u7c7b\u578b", notes="\u83b7\u53d6\u6240\u6709\u5e7f\u544a\u7c7b\u578b")
    @PostMapping(value={"/type/all"})
    public Json<List<AdvertTypeDTO>> getAllAdvertType() {
        return ResultUtil.genSuccessResult((Object)this.advertisementService.getAllAdvertType());
    }

    @ApiOperation(value="1-36-16 \u83b7\u53d6\u6240\u6709\u53ef\u6295\u653e\u5bf9\u8c61", notes="\u83b7\u53d6\u6240\u6709\u53ef\u6295\u653e\u5bf9\u8c61")
    @GetMapping(value={"/deliveryObject/all"})
    public Json<List<AdvertDeliveryObjectDTO>> getAllAdvertDeliveryObject() {
        return ResultUtil.genSuccessResult((Object)this.advertisementService.listAdvertDeliveryObject());
    }
}

