/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.im;

import com.bxm.localnews.admin.constant.RedisConfig;
import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.im.BlockUserDTO;
import com.bxm.localnews.admin.dto.im.ChatRoomMessageDTO;
import com.bxm.localnews.admin.integration.IMIntegrationService;
import com.bxm.localnews.admin.param.BatchMessageParam;
import com.bxm.localnews.admin.param.ChatRoomQueryParam;
import com.bxm.localnews.admin.param.ImBlockParam;
import com.bxm.localnews.admin.param.ImMessageQueryParam;
import com.bxm.localnews.admin.service.im.IMService;
import com.bxm.localnews.admin.vo.im.HistoryChatBean;
import com.bxm.localnews.admin.vo.im.ImMessageBean;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-59 \u5373\u65f6\u901a\u8baf\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"api/im"})
public class ImController
extends CommonController {
    private final IMIntegrationService imIntegrationService;
    private final IMService imService;
    private final RedisStringAdapter redisStringAdapter;

    @Autowired
    public ImController(IMIntegrationService imIntegrationService, IMService imService, RedisStringAdapter redisStringAdapter) {
        this.imIntegrationService = imIntegrationService;
        this.imService = imService;
        this.redisStringAdapter = redisStringAdapter;
    }

    @ApiOperation(value="1-59-1 \u67e5\u8be2\u804a\u5929\u8bb0\u5f55\uff08\u4e0d\u652f\u6301\u5206\u9875\uff09", notes="\u53ef\u67e5\u8be2\u53cc\u4eba\u804a\u5929\u548c\u5355\u4eba\u53d1\u8d77\u7684\u804a\u5929")
    @GetMapping(value={"query"})
    public Json<List<ImMessageBean>> query(ImMessageQueryParam param) {
        boolean validFailed;
        boolean bl = validFailed = null == param || param.getReceiver() == null && param.getSender() == null;
        if (validFailed) {
            return Json.build((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u5fc5\u987b\u6709\u53d1\u9001\u4eba\u6216\u63a5\u6536\u4ebaID\uff0c\u65f6\u95f4\u4e5f\u6700\u597d\u63d0\u4f9b");
        }
        return Json.build((Object)this.imService.query(param));
    }

    @ApiOperation(value="1-59-2 \u5c4f\u853d\u7528\u6237", notes="\u7981\u6b62\u7528\u6237\u5728\u6307\u5b9a\u7684\u65f6\u95f4\u6bb5\u5185\u53d1\u8d77\u804a\u5929")
    @PostMapping(value={"block"})
    public Json<Boolean> block(@RequestBody ImBlockParam param) {
        this.redisStringAdapter.set(this.getBlockRedisKey(param.getUserId()), (Object)param.getEndTime());
        this.redisStringAdapter.expire(this.getBlockRedisKey(param.getUserId()), param.getEndTime());
        return Json.build((Object)this.imIntegrationService.block(param.getUserId(), param.getEndTime()));
    }

    @ApiOperation(value="1-59-3 \u89e3\u9664\u5c4f\u853d\u7528\u6237", notes="\u5141\u8bb8\u7528\u6237\u8fdb\u884c\u804a\u5929")
    @PostMapping(value={"unblock"})
    public Json<Boolean> unblock(@RequestParam(value="userId") Long userId) {
        this.redisStringAdapter.remove(this.getBlockRedisKey(userId));
        return Json.build((Object)this.imIntegrationService.unblock(userId));
    }

    @ApiOperation(value="1-59-4 \u67e5\u8be2\u7528\u6237\u5c4f\u853d\u7ed3\u675f\u65f6\u95f4")
    @GetMapping(value={"queryUserBlockEndTime"})
    public Json<Date> queryUserBlockEndTime(@RequestParam(value="userId") Long userId) {
        return Json.build((Object)this.redisStringAdapter.get(this.getBlockRedisKey(userId), Date.class));
    }

    @ApiOperation(value="1-59-5 \u83b7\u53d6\u7528\u6237token", notes="\u7528\u6237\u5fc5\u987b\u5728\u7528\u6237\u5e93\u4e2d\u5b58\u5728")
    @ApiImplicitParam(value="userId", name="\u83b7\u53d6token\u7684\u76ee\u6807\u7528\u6237ID")
    @GetMapping(value={"token"})
    public Json<String> getToken(@RequestParam(value="userId") Long userId) {
        return Json.ok((Object)this.imIntegrationService.token(userId));
    }

    @ApiOperation(value="1-59-6 \u83b7\u53d6\u9a6c\u7532\u53f7\u8fd1\u671f\u804a\u5929\u5bf9\u8c61\u4fe1\u606f")
    @ApiImplicitParam(value="userId", name="\u9a6c\u7532\u53f7ID")
    @GetMapping(value={"histories"})
    public Json<List<HistoryChatBean>> getHistoryUser(Long userId) {
        return Json.ok((Object)this.imService.queryHistory(userId));
    }

    @ApiOperation(value="1-59-7 \u521b\u5efa\u804a\u5929\u5ba4")
    @PostMapping(value={"createChatRoom"})
    public Json<Boolean> createChatRoom(@RequestParam(value="areaCode") String areaCode) {
        return Json.build((Object)this.imService.createChatRoom(areaCode));
    }

    @ApiOperation(value="1-59-8 \u8bed\u97f3\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"getVoiceByContent"})
    public void createChatRoom(@RequestParam(value="id") String id, HttpServletResponse response) {
        this.imService.getVoiceByContent(id, response);
    }

    @ApiOperation(value="1-59-9 \u67e5\u8be2\u804a\u5929\u5ba4\u804a\u5929\u8bb0\u5f55", notes="")
    @GetMapping(value={"queryChatRoomRecord"})
    public Json<PageWarper<ChatRoomMessageDTO>> queryChatRoomRecord(ChatRoomQueryParam param) {
        return Json.build((Object)this.imService.queryChatRoomRecord(param));
    }

    @ApiOperation(value="1-59-10 \u67e5\u8be2\u804a\u5929\u5ba4\u88ab\u7981\u8a00\u7528\u6237", notes="")
    @GetMapping(value={"queryChatRoomBlockUser"})
    @ApiImplicitParam(value="\u804a\u5929\u5ba4id", name="chatRoomId")
    public Json<List<BlockUserDTO>> queryChatRoomBlockUser(String chatRoomId) {
        return Json.build((Object)this.imService.queryChatRoomBlockUser(chatRoomId));
    }

    @ApiOperation(value="1-59-11 \u7981\u8a00\u804a\u5929\u5ba4\u7528\u6237", notes="")
    @PostMapping(value={"blockChatRoomUser"})
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u804a\u5929\u5ba4id", name="chatRoomId"), @ApiImplicitParam(value="\u7528\u6237id", name="userId"), @ApiImplicitParam(value="\u7981\u8a00\u622a\u6b62\u65f6\u95f4", name="time")})
    public Json<Boolean> blockChatRoomUser(@RequestParam(value="chatRoomId") String chatRoomId, @RequestParam(value="userId") Long userId, @RequestParam(value="time") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date time) {
        AdminUser loginUser = this.getLoginUser();
        Boolean flag = this.imService.blockChatRoomUser(chatRoomId, time, userId, loginUser.getId());
        return Json.build((Object)flag);
    }

    @ApiOperation(value="1-59-12 \u89e3\u9664\u7981\u8a00\u7684\u804a\u5929\u5ba4\u7528\u6237", notes="")
    @PostMapping(value={"unBlockChatRoomUser"})
    @ApiImplicitParams(value={@ApiImplicitParam(value="\u804a\u5929\u5ba4id", name="chatRoomId"), @ApiImplicitParam(value="\u7528\u6237id", name="userId")})
    public Json<Boolean> unBlockChatRoomUser(String chatRoomId, Long userId) {
        AdminUser loginUser = this.getLoginUser();
        Boolean flag = this.imService.unBlockChatRoomUser(chatRoomId, userId, loginUser.getId());
        return Json.build((Object)flag);
    }

    @ApiOperation(value="1-59-13 \u9a6c\u7532\u53f7\u6279\u91cf\u53d1\u9001\u6d88\u606f\u81f3\u7528\u6237", notes="")
    @PostMapping(value={"batch/send/message"})
    public Json<Boolean> unBlockChatRoomUser(@RequestBody BatchMessageParam batchMessageParam) {
        Boolean flag = this.imService.sendBatchMessage(batchMessageParam);
        return Json.build((Object)flag);
    }

    private KeyGenerator getBlockRedisKey(Long userId) {
        return RedisConfig.IM_BLOCK_LIST.copy().appendKey((Object)userId);
    }
}

