/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.security;

import com.bxm.localnews.admin.controller.CommonController;
import com.bxm.localnews.admin.dto.AdminUserDTO;
import com.bxm.localnews.admin.dto.CurrentUserVo;
import com.bxm.localnews.admin.dto.LoginSuccessWarper;
import com.bxm.localnews.admin.param.AdminUserParam;
import com.bxm.localnews.admin.service.security.AdminRoleService;
import com.bxm.localnews.admin.service.security.AdminUserRoleService;
import com.bxm.localnews.admin.service.security.AdminUserService;
import com.bxm.localnews.admin.service.security.JwtTokenService;
import com.bxm.localnews.admin.vo.security.AdminRole;
import com.bxm.localnews.admin.vo.security.AdminUser;
import com.bxm.localnews.admin.vo.security.AdminUserRole;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-16 [\u7ba1\u7406]\u540e\u53f0\u7528\u6237\u7ba1\u7406\u63a5\u53e3"}, description="\u5305\u542b\u7528\u6237\u767b\u5f55\u3001\u767b\u51fa\u7b49\u529f\u80fd")
@RestController
@RequestMapping(value={"api/admin"})
public class AdminUserController
extends CommonController {
    @Resource
    private AdminUserService adminUserService;
    @Resource
    private AdminRoleService adminRoleService;
    @Resource
    private AdminUserRoleService adminUserRoleService;
    @Resource
    private JwtTokenService jwtTokenService;

    @ApiOperation(value="1-16-1 \u767b\u51fa", notes="")
    @ApiImplicitParam(name="userName", value="\u767b\u51fa\u7684\u7528\u6237\u8d26\u53f7")
    @PostMapping(value={"/logout"})
    public Json logout(@RequestParam String userName, HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        this.adminUserService.clearCacheUser(userName);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="1-16-2 \u7528\u6237\u767b\u5f55", notes="\u540e\u7eed\u6b64token\u5fc5\u987b\u5728\u8bf7\u6c42\u4e2d\u643a\u5e26")
    @PostMapping(value={"toLoginNew"})
    public Json<LoginSuccessWarper> loginAjax(AdminUserDTO sysUser) {
        if (StringUtils.isEmpty((CharSequence)sysUser.getUsername()) || StringUtils.isEmpty((CharSequence)sysUser.getPassword())) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef,\u7528\u6237\u540d\u3001\u5bc6\u7801\u5fc5\u987b\u8f93\u5165");
        }
        AdminUser cacheUser = this.adminUserService.getCacheUser(sysUser.getUsername());
        if (cacheUser.getStatus() != 0) {
            return ResultUtil.genFailedResult((String)"\u8be5\u7528\u6237\u5df2\u88ab\u7981\u7528");
        }
        String encodePwd = MD5Util.hgmd5((String)sysUser.getPassword());
        if (null == cacheUser || StringUtils.notEquals((CharSequence)encodePwd, (CharSequence)cacheUser.getPassword())) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7528\u6237\u540d\u3001\u5bc6\u7801\u9519\u8bef");
        }
        String token = this.jwtTokenService.generateToken(cacheUser);
        LoginSuccessWarper warper = new LoginSuccessWarper();
        warper.setToken(token);
        warper.setUserName(cacheUser.getUsername());
        warper.setRealName(cacheUser.getName());
        List roleCodes = this.adminRoleService.selectByUserId(cacheUser.getId()).stream().map(AdminRole::getRoleCode).collect(Collectors.toList());
        warper.setRoleList(roleCodes);
        return ResultUtil.genSuccessResult((Object)warper).setErrorMsg("\u767b\u9646\u6210\u529f");
    }

    @ApiOperation(value="1-16-3 \u4fee\u6539\u5bc6\u7801", notes="")
    @RequestMapping(value={"modifyPassword"}, method={RequestMethod.POST})
    @ResponseBody
    public Json modifyPassword(AdminUserDTO sysUser) {
        return this.adminUserService.modifyPassword(sysUser);
    }

    @ApiOperation(value="1-16-4 \u7ba1\u7406\u540e\u53f0\u7528\u6237\u5217\u8868", notes="")
    @GetMapping(value={"list"})
    @ResponseBody
    public Json<PageWarper<AdminUserDTO>> getAdminUserList(AdminUserParam adminUserParam) {
        return ResultUtil.genSuccessResult((Object)this.adminUserService.queryAdminUsers(adminUserParam));
    }

    @ApiOperation(value="1-16-5 \u4fdd\u5b58\u7528\u6237", notes="")
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public Json saveAdminUser(AdminUserDTO adminUserDTO) {
        if (StringUtils.isEmpty((CharSequence)adminUserDTO.getName()) || StringUtils.isEmpty((CharSequence)adminUserDTO.getUsername()) || StringUtils.isEmpty((CharSequence)adminUserDTO.getPhone()) || StringUtils.isEmpty((CharSequence)adminUserDTO.getRoleId())) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        AdminUser adminUser = this.adminUserService.selectByUsername(adminUserDTO.getUsername().trim());
        if (adminUserDTO.getId() != null) {
            if (adminUser != null && !adminUser.getId().equals(adminUserDTO.getId())) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7528\u6237\u540d\u91cd\u590d");
            }
            adminUserDTO.setUpdateTime(new Date());
            adminUserDTO.setUpdateUser("system");
            this.adminUserService.updateByPrimaryKeySelective((AdminUser)adminUserDTO);
        } else {
            if (adminUser != null) {
                return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7528\u6237\u540d\u91cd\u590d");
            }
            this.adminUserService.upsert(adminUserDTO);
        }
        String[] roleIds = adminUserDTO.getRoleId().split(",");
        this.adminUserRoleService.deleteByUserId(adminUserDTO.getId());
        for (String roleId : roleIds) {
            Integer intRoleId = Integer.parseInt(roleId);
            AdminRole adminRole = this.adminRoleService.selectByPrimaryKey(intRoleId);
            if (adminRole == null) continue;
            AdminUserRole adminUserRole = new AdminUserRole();
            adminUserRole.setRoleId(intRoleId);
            adminUserRole.setUserId(adminUserDTO.getId());
            this.adminUserRoleService.insertSelective(adminUserRole);
        }
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="1-16-6 \u9501\u5b9a\u6216\u89e3\u9501\u7528\u6237", notes="")
    @RequestMapping(value={"updateUserStatus"}, method={RequestMethod.POST})
    @ResponseBody
    public Json updateUserStatus(AdminUser user) {
        if (user.getId() == null || user.getStatus() == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        AdminUser adminUser = new AdminUser();
        adminUser.setId(user.getId());
        adminUser.setStatus(user.getStatus());
        this.adminUserService.updateByPrimaryKeySelective(adminUser);
        return ResultUtil.genSuccessMsg();
    }

    @ApiOperation(value="1-16-7 \u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u548c\u6743\u9650", notes="")
    @GetMapping(value={"getCurrentUserInfo"})
    @ResponseBody
    public Json<CurrentUserVo> getCurrentUserInfo() {
        AdminUser adminUser = this.getLoginUser();
        if (adminUser != null) {
            CurrentUserVo currentUserVo = new CurrentUserVo(this.adminRoleService.selectByUserId(adminUser.getId()), adminUser.getId(), adminUser.getUsername(), adminUser.getPhone());
            return ResultUtil.genSuccessResult((Object)currentUserVo);
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @ApiOperation(value="1-16-8 \u4fee\u6539\u7528\u6237\u5bc6\u7801\uff08\u7ba1\u7406\u5458\u4e13\u7528\uff09", notes="")
    @PostMapping(value={"/password"})
    @ResponseBody
    public Json modifyPasswordByAdmin(AdminUserDTO sysUser) {
        return this.adminUserService.modifyPasswordByAdmin(sysUser);
    }

    @ApiOperation(value="1-16-9 \u4fee\u6539\u7528\u6237\u89d2\u8272", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="\u7528\u6237id", value="userId"), @ApiImplicitParam(name="\u89d2\u8272id", value="roleId")})
    @PostMapping(value={"/updateUserRole"})
    @ResponseBody
    public Json updateUserRole(Long userId, Integer roleId) {
        this.adminUserService.updateUserRole(userId, roleId);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="1-16-10 \u83b7\u53d6\u7ba1\u7406\u540e\u53f0\u6240\u6709\u53ef\u7528\u8d26\u53f7\u5217\u8868", notes="")
    @GetMapping(value={"user/list"})
    public Json<List<AdminUserDTO>> getUserList() {
        return ResultUtil.genSuccessResult((Object)this.adminUserService.getAvailableAdminUser());
    }
}

