/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.controller.security;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.admin.dto.UserBlockDTO;
import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.service.base.AdminChannelService;
import com.bxm.localnews.admin.service.security.AdminBlockUserService;
import com.bxm.localnews.admin.service.security.AdminUserBaseInfoService;
import com.bxm.localnews.admin.vo.Channel;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-17 [\u7ba1\u7406]\u7528\u6237\u7ba1\u7406"}, description="\u7528\u6237\u76f8\u5173\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/admin/user"})
public class AdminUserManageController {
    private static final Logger LOG = LoggerFactory.getLogger(AdminUserManageController.class);
    @Resource
    private AdminChannelService adminChannelService;
    @Resource
    private AdminUserBaseInfoService adminUserBaseInfoService;
    @Autowired
    private AdminBlockUserService blockUserService;

    @ApiOperation(value="1-17-1 \u6839\u636e\u6761\u4ef6\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5217\u8868", notes="")
    @RequestMapping(value={"queryUserInfoList"}, method={RequestMethod.GET})
    @ResponseBody
    public Json<PageWarper<UserInfoDTO>> queryUserInfoList(UserInfoParam userInfoParam) {
        LOG.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5217\u8868\u7684\u67e5\u8be2\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)userInfoParam));
        return ResultUtil.genSuccessResult((Object)this.adminUserBaseInfoService.queryUserInfoDTO(userInfoParam));
    }

    @ApiOperation(value="1-17-2 \u67e5\u770b\u7528\u6237\u57fa\u672c\u4fe1\u606f", notes="")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    @RequestMapping(value={"queryUserBaseInfoByUserId"}, method={RequestMethod.GET})
    @ResponseBody
    public Json<User> queryUserInfoByUserId(@RequestParam(value="userId", required=false) String userId) {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        User userBaseInfo = this.adminUserBaseInfoService.selectByUserId(Long.valueOf(Long.parseLong(userId)));
        if (userBaseInfo == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return ResultUtil.genSuccessResult((Object)userBaseInfo);
    }

    @ApiOperation(value="1-17-3 \u8bbe\u7f6e\u548c\u53d6\u6d88\u7528\u6237\u9ed1\u540d\u5355", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id"), @ApiImplicitParam(name="state", value="\u72b6\u6001")})
    @RequestMapping(value={"updateUserBlack"}, method={RequestMethod.GET})
    @ResponseBody
    public Json updateUserBlack(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="state", required=false) String state) {
        if (StringUtils.isEmpty((CharSequence)String.valueOf(userId)) || StringUtils.isEmpty((CharSequence)state)) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        HashMap map = Maps.newHashMap();
        map.put("userId", userId);
        map.put("state", state);
        boolean flag = this.adminUserBaseInfoService.updateUserBlack((Map)map);
        if (flag) {
            return ResultUtil.genSuccessMsg((String)"\u64cd\u4f5c\u6210\u529f");
        }
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u64cd\u4f5c\u5931\u8d25");
    }

    @ApiOperation(value="1-17-4 \u83b7\u53d6\u6e20\u9053\u5217\u8868", notes="")
    @RequestMapping(value={"getChannelList"}, method={RequestMethod.GET})
    @ResponseBody
    public Json<List<Channel>> getChannelList() {
        List channelList = this.adminChannelService.selectRegistChannelList();
        return ResultUtil.genSuccessResult((Object)channelList);
    }

    @ApiOperation(value="1-17-5 \u5220\u9664\u7528\u6237", notes="")
    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ApiImplicitParam(name="userId", value="\u7528\u6237id")
    public Json deleteUser(@RequestParam(value="userId") Long userId) {
        this.adminUserBaseInfoService.deleteUser(userId);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="1-17-6 \u83b7\u53d6\u865a\u62df\u7528\u6237\u5217\u8868")
    @RequestMapping(value={"getVirtualUserList"}, method={RequestMethod.GET})
    public Json<List<UserInfoDTO>> getVirtualUserList() {
        return ResultUtil.genSuccessResult((Object)this.adminUserBaseInfoService.getVirtualUserList());
    }

    @ApiOperation(value="1-17-7 \u83b7\u53d6\u7528\u6237\u9650\u5236\u4fe1\u606f")
    @GetMapping(value={"/block/info"})
    public Json<UserBlockDTO> getBlockInfo(@RequestParam Long userId) {
        return ResultUtil.genSuccessResult((Object)this.blockUserService.getInfo(userId));
    }

    @ApiOperation(value="1-17-8 \u7f16\u8f91\u7528\u6237\u9650\u5236\u4fe1\u606f")
    @PostMapping(value={"/block/edit"})
    public Json<Boolean> editBlockInfo(@RequestBody UserBlockDTO userBlockDTO) {
        return ResultUtil.genSuccessResult((Object)this.blockUserService.editUserBlock(userBlockDTO));
    }
}

