package com.bxm.localnews.admin.domain;

import java.util.List;

import com.bxm.localnews.admin.vo.CommodityCodeBean;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface CommodityCodeMapper {

    int deleteByPrimaryKey(Long id);

    int insert(CommodityCodeBean record);

    int insertSelective(CommodityCodeBean record);

    CommodityCodeBean selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(CommodityCodeBean record);

    int updateByPrimaryKey(CommodityCodeBean record);

    /**
     * 获取num个未使用的商品信息
     *
     * @param commodityId 商品ID
     * @param num         获取商品数量
     * @return 商品编码信息列表
     */
    List<CommodityCodeBean> getUnusedCommodities(@Param("commodityId") long commodityId, @Param("num") int num);

    List<CommodityCodeBean> getUseCommoditiesAndPrivilege(@Param("commodityId") long commodityId, @Param("num") int num,
                                                          @Param("privilegeId") long privilegeId);

    /**
     * 获取商品下已使用的编码
     *
     * @param commodityId 商品ID
     * @return 商品下已使用的商品编码列表
     */
    List<CommodityCodeBean> getUsedCodes(long commodityId);

    /**
     * 活动开奖时，将活动中奖人对应的编码设置为已使用状态
     *
     * @param privilegeId 活动ID
     * @param commodityId 商品ID
     * @return 操作结果
     */
    int updateToUsed(@Param("privilegeId") long privilegeId, @Param("commodityId") long commodityId);

    /**
     * 根据商品删除商品编码
     *
     * @param commdotityId 商品ID
     * @return 删除数量
     */
    int deleteByCommodityId(long commdotityId);

}