package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.dto.UserInfoDTO;
import com.bxm.localnews.admin.param.UserInfoParam;
import com.bxm.localnews.admin.vo.User;
import com.bxm.localnews.admin.vo.UserLoginHistory;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface UserMapper {

    List<UserInfoDTO> queryUserByPageSize(UserInfoParam userInfoParam);

    boolean updateUserBlack(Map<String, Object> map);

    User selectByUserId(@Param("userId") long userId);

    UserLoginHistory selectHistoryByUserId(@Param("userId") long userId);

    String selectLocationByUserId(@Param("userId") long userId);

    int countByUserId(@Param("userId") long userId);

//    int addVirtualUser(@Param("nickname") String nickname, @Param("headImg") String headImg);

    int deleteUser(@Param("userId") Long userId);

    int deleteUserEquipment(@Param("equipment") String equipment);

    int updateUser(@Param("userId") Long userId, @Param("weChat") String weChat);

    int updateVipViewRecord(@Param("wechat") String wechat, @Param("newWeChat") String newWeChat);

    int updateVipRecord(@Param("userId") Long userId, @Param("weChat") String weChat);

    List<UserInfoDTO> queryUserInfoList(UserInfoParam userInfoParam);

    String getNicknameById(@Param("userId") long userId);

    int minusPostNum(@Param("userId") Long userId);

    Integer getStateById(@Param("userId") long userId);

    List<UserInfoDTO> getVirtualUserList();

    int insertSelective(User record);

    int updateByPrimaryKeySelective(User user);
}
