package com.bxm.localnews.admin.domain;

import com.bxm.localnews.admin.dto.OrderInfoDTO;
import com.bxm.localnews.admin.dto.security.ActiveCardDTO;
import com.bxm.localnews.admin.dto.security.UserVipDTO;
import com.bxm.localnews.admin.param.UserActivationCardParam;
import com.bxm.localnews.admin.param.security.ActiveCardPageQueryParam;
import com.bxm.localnews.admin.vo.security.UserParentInfoBean;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author:jieli.xu 用户vip信息
 */
@Mapper
public interface UserVipMapper {
    /**
     * 批量获取用户的vip信息
     *
     * @param userIds ： 用户id集合
     * @return
     */
    List<UserVipDTO> getVipListByUserIds(@Param("userIds") List<Long> userIds);

    /**
     * 更新用户的激活码次数：进行累加
     *
     * @param userId :
     * @param num    ： 次数配置
     * @return
     */
    int updateInviteNumByUserId(@Param("userId") Long userId, @Param("num") Integer num);

    /**
     * 新增会员信息
     */
    int insertSelective(UserVipDTO userVipDTO);

    /**
     * 更新会员信息
     *
     * @param userVipDTO
     * @return
     */
    int updateUserVipSelective(UserVipDTO userVipDTO);

    /**
     * 分页查询：开卡管理列表
     *
     * @param userActivationCardParam
     * @return 列表数据
     */
    List<OrderInfoDTO> getPageList(UserActivationCardParam userActivationCardParam);

    /**
     * 根据用户ID获取上级用户信息
     *
     * @param userIds
     * @return
     */
    List<UserParentInfoBean> getParentInfoById(@Param("userIds") List<Long> userIds);

    /**
     * 删除vip信息表
     *
     * @param userId :用户id
     * @return
     */
    int delete(@Param("userId") Long userId);

    /**
     * 分页查询激活码信息
     *
     * @param param 分页查询参数
     * @return 激活码与卡号信息
     */
    List<ActiveCardDTO> queryActiveCardByPage(ActiveCardPageQueryParam param);
}
