package com.bxm.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * swagger api 配置
 * @author liujia
 */
@Configuration
@EnableSwagger2
@Profile({"dev", "test"})
public class SwaggerConfiguration {

    @Value("${swagger.api.version:1.0}")
    private String version;

    @Bean
    public Docket createBaseRestApi() {
        ApiInfo apiInfo = new ApiInfoBuilder()
                .title("后台管理相关接口")
                .description("包括基础管理和运维管理")
                .contact(new Contact("liujia", "", "liujia@bianxianmao.com"))
                .version(this.version)
                .build();
        return this.commonSetting(new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo)
                .groupName("后台管理相关接口")
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.bxm.localnews.admin"))
                .paths(PathSelectors.any())
                .build());
    }

    private Docket commonSetting(Docket docket) {
        return docket.useDefaultResponseMessages(false);
    }

}