package com.bxm.localnews.admin.facade.controller;

import com.bxm.localnews.admin.domain.VirtualUserMapper;
import com.bxm.localnews.admin.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.admin.param.VirtualUserQueryParam;
import com.bxm.localnews.admin.param.VirtualUserRandomQueryParam;
import com.bxm.localnews.admin.service.base.VirtualUserService;
import com.bxm.localnews.admin.vo.VirtualUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 虚拟用户相关接口
 *
 * @author liujia
 * @date 2020-08-06 17:54
 **/
@RestController
@RequestMapping("/facade/manage/virutal/user")
public class VirtualUserFacadeController {
    private final VirtualUserService virtualUserService;

    private final VirtualUserMapper virtualUserMapper;

    @Autowired
    public VirtualUserFacadeController(VirtualUserService virtualUserService, VirtualUserMapper virtualUserMapper) {
        this.virtualUserService = virtualUserService;
        this.virtualUserMapper = virtualUserMapper;
    }

    @GetMapping("exists")
    public ResponseEntity<Boolean> exists(@RequestParam("userId") Long userId) {
        return ResponseEntity.ok(virtualUserMapper.exists(userId));
    }

    @PostMapping("random")
    public ResponseEntity<List<VirtualUser>> getRandom(@RequestBody VirtualUserRandomQueryParam param) {
        List<VirtualUser> virtualUsers;

        if (null != param.getDeliveryType() || null != param.getIncludeAreaCodes()) {
            virtualUsers = virtualUserMapper.selectRandModelByMutiAreaCode(param);
        } else {
            virtualUsers = virtualUserMapper.selectRandModel(param);
        }

        return ResponseEntity.ok(virtualUsers);
    }

    @PostMapping("list")
    public ResponseEntity<List<VirtualUserOverviewDTO>> list(@RequestBody VirtualUserQueryParam param) {
        return ResponseEntity.ok(virtualUserService.list(param));
    }
}
