package com.bxm.localnews.admin.service;

import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * Created by Arei on 2018/12/3.
 */
@FeignClient("localnews-msg")
public interface SmsIntegService {
    @PostMapping("/tml")
    SendSmsResult sendSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @PostMapping("/custom")
    SendSmsResult sendSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @PostMapping("/group/tml")
    void sendGroupSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @PostMapping("/group/custom")
    void sendGroupSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO);

    @GetMapping("/verify")
    Boolean verifySmsCode(@RequestParam("phoneNo") String phoneNo,
                          @RequestParam("code") String code,
                          @RequestParam("smsTemplate") SmsTemplateEnum smsTemplate);

    @GetMapping("/verify/type")
    Boolean verifySmsCodeByType(@RequestParam("type") Byte type,
                                @RequestParam("phoneNo") String phoneNo,
                                @RequestParam("code") String code);

    @PostMapping("/tml/vcode")
    SendSmsResult sendSmsByVCodeTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO);
}
