/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.facade.PushMsgFeignService;
import com.bxm.localnews.admin.param.PushMsgBuildParam;
import com.bxm.localnews.admin.vo.ForumPost;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.newidea.component.service.BaseService;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PushMsgIntegService
extends BaseService {
    @Resource
    private PushMsgFeignService pushMsgFeignService;

    public void pushMsg(PushMessage message) {
        this.pushMsgFeignService.pushMsg(message);
    }

    public void timingPush(PushMsgBuildParam param) {
        this.pushMsgFeignService.timingPush(param);
    }

    public void removeTimingPush(Long messageId) {
        this.pushMsgFeignService.removeTimingPush(messageId);
    }

    public void pushMsg(ForumPost forumPost, ForumPost existedForumPost, String forumTitle, String h5ServerHost) {
        PushMessage message;
        String content;
        if (existedForumPost.getIsBrilliant() != null && existedForumPost.getIsBrilliant() == 0 && forumPost.getIsBrilliant() != null && forumPost.getIsBrilliant() == 1) {
            content = "\u606d\u559c\uff01\u4f60\u53d1\u5e03\u7684\u3010" + forumTitle + "\u3011\u88ab\u52a0\u7cbe\uff0c\u5956\u52b1\u4f6040\u6735\u5c0f\u7ea2\u82b1\uff0c\u4f60\u7684\u5185\u5bb9\u5c06\u4f1a\u88ab\u66f4\u591a\u4eba\u770b\u5230\u54e6~";
            message = this.getPushMessage(PushMessageEnum.ESSENCE_POST, forumPost, content, h5ServerHost);
            this.pushMsg(message);
        }
        if (existedForumPost.getIsCash() != null && existedForumPost.getIsCash() == 0 && forumPost.getIsCash() != null && forumPost.getIsCash() == 1) {
            content = "\u901f\u6765\u9886\u94b1\uff01\u4f60\u53d1\u5e03\u7684\u3010" + forumTitle + "\u3011\u83b7\u5f97\u4e86\u73b0\u91d1\u5956\u52b1\uff0c\u8bf7\u5feb\u5feb\u8054\u7cfb\u6211\u4eec\u9886\u53d6\uff01";
            message = this.getPushMessage(PushMessageEnum.CASH_POST, forumPost, content, h5ServerHost);
            this.pushMsg(message);
        }
        if (existedForumPost.getIsBroke() != null && existedForumPost.getIsBroke() == 0 && forumPost.getIsBroke() != null && forumPost.getIsBroke() == 1) {
            content = "\u606d\u559c\uff01\u4f60\u53d1\u5e03\u7684\u3010" + forumTitle + "\u3011\u88ab\u9009\u4e3a\u7206\u6599\u5185\u5bb9\uff0c\u5956\u52b1\u4f6050\u6735\u5c0f\u7ea2\u82b1\u3002";
            message = this.getPushMessage(PushMessageEnum.BROKE_POST, forumPost, content, h5ServerHost);
            this.pushMsg(message);
        }
    }

    private PushMessage getPushMessage(PushMessageEnum pushMessageEnum, ForumPost forumPost, String content, String h5ServerHost) {
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)pushMessageEnum);
        Long msgId = this.nextId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("url", (Object)(h5ServerHost + "/servicePrize.html?areaCode=" + forumPost.getAreaCode()));
        info.addExtend("postId", (Object)forumPost.getId());
        PushMessage message = PushMessage.build();
        message.setTitle("");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)forumPost.getUserId()));
        message.setPayloadInfo(info);
        return message;
    }
}

