package com.bxm.localnews.admin.facade;

import com.bxm.localnews.admin.facade.fallback.UserAccountFallbackFactory;
import com.bxm.localnews.admin.param.AccountCashParam;
import com.bxm.localnews.admin.param.AccountGoldParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-user", fallbackFactory = UserAccountFallbackFactory.class)
public interface UserAccountFeignService {

    @PostMapping("facade/user/account/addGold")
    ResponseEntity<Boolean> addGold(@RequestBody AccountGoldParam param);

    @GetMapping("facade/user/account/countGoldByPostId")
    ResponseEntity<Integer> countGoldByPostId(@RequestParam("postId") Long postId, @RequestParam("userId") Long userId);

    @PostMapping("facade/user/account/addCash")
    ResponseEntity<Boolean> addCash(@RequestBody AccountCashParam param);
}
