package com.bxm.localnews.admin.facade;

import com.bxm.localnews.admin.dto.ActiveCodeDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;
import com.bxm.localnews.admin.facade.fallback.UserVipFallbackFactory;
import com.bxm.localnews.admin.param.AddTimesParam;
import com.bxm.localnews.admin.param.OfflineBindRelationParam;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Api(tags = "9-89 [内部]用户VIP相关的接口")
@RequestMapping("facade/user/vip")
@FeignClient(value = "localnews-user", fallbackFactory = UserVipFallbackFactory.class, primary = false)
public interface UserVipFeignService {

    @ApiOperation("9-89-1 手动激活用户的VIP资格")
    @PostMapping("manual/active")
    ResponseEntity<ImportResultDTO> manualActiveVip(@RequestParam("phoneNo") String phoneNo);

    @ApiOperation("9-89-2 批量导出激活码和卡号")
    @PostMapping("batch/export")
    ResponseEntity<List<ActiveCodeDTO>> batchExport(@RequestParam("areaCode") String areaCode,
                                                    @RequestParam("limit") Integer limit);

    @ApiOperation("9-89-3 激活码批量绑定用户")
    @PostMapping("batch/bind")
    ResponseEntity<List<ImportResultDTO>> batchBind(@RequestBody List<OfflineBindRelationParam> params);

    @ApiOperation("9-89-4 给用户增加激活码的可用次数")
    @PostMapping("add/num")
    ResponseEntity<Message> addNum(@RequestBody AddTimesParam param);
}
