/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.facade.MerchantFeignService;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author jieliGG
 * @date 2020/7/20 21:20
 * 商户信息
 **/
@Component
public class MerchantFallbackFactory implements FallbackFactory<MerchantFeignService> {

    @Override
    public MerchantFeignService create(Throwable throwable) {

        return new MerchantFeignService() {
            @Override
            public ResponseEntity<Boolean> deleteMerchantInfoByUid(Long userId) {
                return ResponseEntity.ok(true);
            }
        };
    }
}
