package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.facade.PaymentOrderFacadeService;
import com.bxm.localnews.admin.param.PayRefundParam;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.ResponseJson;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class PaymentOrderFallbackFactory implements FallbackFactory<PaymentOrderFacadeService> {


    @Override
    public PaymentOrderFacadeService create(Throwable throwable) {
        return new PaymentOrderFacadeService() {
            @Override
            public ResponseJson<Message> submitRefund(PayRefundParam payRefundParam) {
                return ResponseJson.ok(Message.build(false));
            }
        };
    }
}

