package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.facade.UserAccountFeignService;
import com.bxm.localnews.admin.param.AccountCashParam;
import com.bxm.localnews.admin.param.AccountGoldParam;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserAccountFallbackFactory implements FallbackFactory<UserAccountFeignService> {

    @Override
    public UserAccountFeignService create(Throwable throwable) {
        return new UserAccountFeignService() {
            @Override
            public ResponseEntity<Boolean> addGold(AccountGoldParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Boolean> addCash(AccountCashParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Integer> countGoldByPostId(Long postId, Long userId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
