package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.facade.UserFeignService;
import com.bxm.localnews.admin.facade.WithdrawFeignService;
import com.bxm.localnews.admin.vo.WithdrawFlow;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author xujieli
 * @desc
 */
@Component
@Slf4j
public class UserFallbackFactory implements FallbackFactory<UserFeignService> {

    @Override
    public UserFeignService create(Throwable throwable) {
        return new UserFeignService() {
            @Override
            public ResponseEntity<Boolean> delUserCacheBatch(List<Long> userIds) {
                return ResponseEntity.ok(Boolean.TRUE);
            }
        };
    }
}
