package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.dto.ActiveCodeDTO;
import com.bxm.localnews.admin.dto.ImportResultDTO;
import com.bxm.localnews.admin.facade.UserFeignService;
import com.bxm.localnews.admin.facade.UserVipFeignService;
import com.bxm.localnews.admin.param.AddTimesParam;
import com.bxm.localnews.admin.param.OfflineBindRelationParam;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author liujia
 * @date 2020/6/3 20:28
 **/
@Component
public class UserIntegrationService {

    @Autowired
    private UserFeignService userFeignService;

    /**
     * 批量删除用户的redis缓存
     * @param userIds ： 用户id集合
     * @return ： 删除结果：只为true
     */
    public Boolean delUserCacheBatch( List<Long> userIds){
        ResponseEntity<Boolean> result = userFeignService.delUserCacheBatch(userIds);
        return result.getBody();
    }

}
