/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.facade.fallback;

import com.bxm.localnews.admin.dto.im.BlockUserDTO;
import com.bxm.localnews.admin.facade.IMFacadeService;
import com.bxm.localnews.admin.param.BatchMessageParam;
import com.bxm.localnews.admin.param.ChatRoomOperationParam;
import com.bxm.localnews.admin.param.CreateRedPacketTaskFacadeParam;
import com.bxm.localnews.admin.param.RemoveRedPacketTaskFacadeParam;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class IMFallbackFactory
implements FallbackFactory<IMFacadeService> {
    private static final Logger log = LoggerFactory.getLogger(IMFallbackFactory.class);

    public IMFacadeService create(final Throwable throwable) {
        return new IMFacadeService(){

            @Override
            public ResponseEntity<Boolean> block(Long userId, int minutes) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> unblock(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok((Object)Boolean.FALSE);
            }

            @Override
            public ResponseEntity<String> token(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body(null);
            }

            @Override
            public ResponseEntity<Boolean> createChatRoom(String areaCode, Long assistantUserId, String areaName) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body((Object)false);
            }

            @Override
            public ResponseEntity<Boolean> createRedPacketTask(CreateRedPacketTaskFacadeParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body((Object)false);
            }

            @Override
            public ResponseEntity<Boolean> removeRedPacketTask(RemoveRedPacketTaskFacadeParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().body((Object)false);
            }

            @Override
            public ResponseEntity<List<BlockUserDTO>> queryChatRoomBlockUser(String chatRoomId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> blockChatRoomUser(ChatRoomOperationParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> unBlockChatRoomUser(ChatRoomOperationParam param) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }

            @Override
            public ResponseEntity<Boolean> sendBatchMessage(BatchMessageParam batchMessageParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.badRequest().build();
            }
        };
    }
}

