/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.admin.integration;

import com.bxm.localnews.admin.dto.im.BlockUserDTO;
import com.bxm.localnews.admin.facade.IMFacadeService;
import com.bxm.localnews.admin.param.BatchMessageParam;
import com.bxm.localnews.admin.param.ChatRoomOperationParam;
import com.bxm.localnews.admin.param.CreateRedPacketTaskFacadeParam;
import com.bxm.localnews.admin.param.RemoveRedPacketTaskFacadeParam;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class IMIntegrationService {
    private IMFacadeService imFacadeService;

    @Autowired
    public IMIntegrationService(IMFacadeService imFacadeService) {
        this.imFacadeService = imFacadeService;
    }

    public Boolean block(Long userId, Date endTime) {
        Long mintues = DateUtils.getDiffMinutes((Date)new Date(), (Date)endTime, (boolean)true);
        return (Boolean)this.imFacadeService.block(userId, mintues.intValue()).getBody();
    }

    public Boolean unblock(Long userId) {
        return (Boolean)this.imFacadeService.unblock(userId).getBody();
    }

    public Boolean createChatRoom(String areaCode, Long assistantUserId, String areaName) {
        return (Boolean)this.imFacadeService.createChatRoom(areaCode, assistantUserId, areaName).getBody();
    }

    public Boolean createRedPacketTask(CreateRedPacketTaskFacadeParam param) {
        return (Boolean)this.imFacadeService.createRedPacketTask(param).getBody();
    }

    public Boolean removeRedPacketTask(RemoveRedPacketTaskFacadeParam param) {
        return (Boolean)this.imFacadeService.removeRedPacketTask(param).getBody();
    }

    public String token(Long userId) {
        ResponseEntity<String> response = this.imFacadeService.token(userId);
        if (response.getBody() == null) {
            return null;
        }
        return (String)response.getBody();
    }

    public List<BlockUserDTO> queryChatRoomBlockUser(String chatRoomId) {
        ResponseEntity<List<BlockUserDTO>> response = this.imFacadeService.queryChatRoomBlockUser(chatRoomId);
        if (response.getBody() == null) {
            return null;
        }
        return (List)response.getBody();
    }

    public boolean blockChatRoomUser(ChatRoomOperationParam param) {
        ResponseEntity<Boolean> response = this.imFacadeService.blockChatRoomUser(param);
        if (response.getBody() == null) {
            return false;
        }
        return (Boolean)response.getBody();
    }

    public Boolean unBlockChatRoomUser(ChatRoomOperationParam param) {
        ResponseEntity<Boolean> response = this.imFacadeService.unBlockChatRoomUser(param);
        if (response.getBody() == null) {
            return false;
        }
        return (Boolean)response.getBody();
    }

    public Boolean sendBatchMessage(BatchMessageParam batchMessageParam) {
        ResponseEntity<Boolean> response = this.imFacadeService.sendBatchMessage(batchMessageParam);
        if (response.getBody() == null) {
            return false;
        }
        return (Boolean)response.getBody();
    }
}

