package com.bxm.localnews.admin.dto;

import com.bxm.localnews.admin.vo.LocationRelationBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;


@ApiModel(description = "区域详情实体")
public class AreaInfoDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("一级区域编码")
    private String provinceCode;

    @ApiModelProperty("一级区域名称")
    private String provinceName;

    @ApiModelProperty("二级区域编码")
    private String code;

    @ApiModelProperty("二级区域名称")
    private String name;

    @ApiModelProperty("常住人口")
    private String population;

    @ApiModelProperty("地区描述（文案性质的描述），支持html")
    private String description;

    @ApiModelProperty("覆盖率")
    private String coverRate;

    @ApiModelProperty("传播率")
    private String transmissionRate;

    @ApiModelProperty(value = "是否启用VIP，1：启用，0：禁用", allowableValues = "0,1")
    private Byte enableVip;

    @ApiModelProperty(value = "激活VIP需要邀请人数")
    private int invitedCount;

    @ApiModelProperty(value = "微信分享话术配置项")
    private List<LocationRelationBean> shareWechatSeg;

    @ApiModelProperty(value = "微信朋友圈分享话术配置项")
    private List<LocationRelationBean> shareMomentSeg;

    public List<LocationRelationBean> getShareWechatSeg() {
        return shareWechatSeg;
    }

    public void setShareWechatSeg(List<LocationRelationBean> shareWechatSeg) {
        this.shareWechatSeg = shareWechatSeg;
    }

    public List<LocationRelationBean> getShareMomentSeg() {
        return shareMomentSeg;
    }

    public void setShareMomentSeg(List<LocationRelationBean> shareMomentSeg) {
        this.shareMomentSeg = shareMomentSeg;
    }

    public int getInvitedCount() {
        return invitedCount;
    }

    public void setInvitedCount(int invitedCount) {
        this.invitedCount = invitedCount;
    }

    public Byte getEnableVip() {
        return enableVip;
    }

    public void setEnableVip(Byte enableVip) {
        this.enableVip = enableVip;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPopulation() {
        return population;
    }

    public void setPopulation(String population) {
        this.population = population;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCoverRate() {
        return coverRate;
    }

    public void setCoverRate(String coverRate) {
        this.coverRate = coverRate;
    }

    public String getTransmissionRate() {
        return transmissionRate;
    }

    public void setTransmissionRate(String transmissionRate) {
        this.transmissionRate = transmissionRate;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}