package com.bxm.localnews.admin.param;

import com.bxm.localnews.admin.vo.LocationRelationBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * C_AREA_INFO
 *
 * @author shentao
 */
@ApiModel(description = "地区信息参数实体")
@Data
public class AreaInfoParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty(value = "区域编码", required = true)
    private String code;

    @ApiModelProperty("区域名称(更新时不用传)")
    private String name;

    @ApiModelProperty("常住人口")
    private String population;

    @ApiModelProperty(value = "地区描述（文案性质的描述），支持html", hidden = true)
    @JsonIgnore
    private String description;

    @ApiModelProperty("覆盖率")
    private String coverRate;

    @ApiModelProperty("传播率")
    private String transmissionRate;

    @ApiModelProperty("开通类型：1:vip 2:推广赚钱")
    private Integer type;

    @ApiModelProperty(value = "是否启用VIP，1：启用，0：禁用", allowableValues = "0,1", required = true)
    private Byte enableVip;

    @ApiModelProperty(value = "激活VIP需要邀请人数", required = true)
    private int invitedCount;

    @ApiModelProperty(value = "VIP总价值", required = true)
    private String value;

    @ApiModelProperty("是否启用推广赚钱")
    private Byte enablePaidPromote;

    @ApiModelProperty("新人红包金额")
    private String newRedPacket;

    @ApiModelProperty("推广赏金")
    private String promoteBounty;

    @ApiModelProperty(value = "微信分享话术配置项")
    private List<LocationRelationBean> shareWechatSeg;

    @ApiModelProperty(value = "微信分享图片配置项")
    private List<LocationRelationBean> shareWechatImgSeg;

    @ApiModelProperty(value = "微信朋友圈分享话术配置项")
    private List<LocationRelationBean> shareMomentSeg;

    @ApiModelProperty(value = "微信朋友圈图片配置项")
    private List<LocationRelationBean> shareMomentImgSeg;

    @ApiModelProperty(value = "微信小程序分享话术配置项")
    private List<LocationRelationBean> shareMiniAppWechatSeg;

    @ApiModelProperty(value = "微信小程序分享图片配置项")
    private List<LocationRelationBean> shareMiniAppWechatImgSeg;

    @ApiModelProperty(value = "微信小程序朋友圈分享话术配置项")
    private List<LocationRelationBean> shareMiniAppMomentSeg;

    @ApiModelProperty(value = "微信小程序朋友圈图片配置项")
    private List<LocationRelationBean> shareMiniAppMomentImgSeg;

    @ApiModelProperty(value = "提醒召回小程序分享")
    private List<LocationRelationBean> recallMiniAppWechatImgSeg;

    @ApiModelProperty(value = "提醒召回小程序图片分享")
    private List<LocationRelationBean> recallMiniAppMomentImgSeg;

    @ApiModelProperty(value = "是否启用社区内容，1：启用，0：禁用")
    private Integer enableCommunityContent;

    @ApiModelProperty(value = "是否启用首页发帖，1：启用，0：禁用")
    private Integer enableIndexPublish;

    @ApiModelProperty(value = "是否启用客服小助手，1：启用，0：禁用")
    private Integer enableCustomerService;

    @ApiModelProperty(value = "客服微信号")
    private String customerServiceNumber;

    @ApiModelProperty(value = "客服二维码")
    private String customerServiceQrCode;

}