package com.bxm.localnews.admin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 可开通城市信息参数实体
 * @author
 */
@ApiModel(description = "可开通城市信息参数实体")
public class LocationParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("地区编码")
    private String code;

    @ApiModelProperty("地区简称【模糊匹配】")
    private String name;

    @ApiModelProperty("是否热门城市（1表示true）")
    private Byte hot;

    @ApiModelProperty("是否显示（1表示true）")
    private Byte show;

    @ApiModelProperty("城市级别（2：市、3：县（区））")
    private Byte level;

    @ApiModelProperty("城市拼音【小写 模糊匹配】")
    private String pinyin;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    public Byte getShow() {
        return show;
    }

    public void setShow(Byte show) {
        this.show = show;
    }

    public Byte getLevel() {
        return level;
    }

    public void setLevel(Byte level) {
        this.level = level;
    }

    public String getPinyin() {
        return pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }


}