package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;

import io.swagger.annotations.ApiModelProperty;

public class BaseMerchantBean extends BaseBean {

    @ApiModelProperty("商户ID")
    private long id;

    @ApiModelProperty("商户名称")
    private String name;

    @ApiModelProperty("商家类型")
    private String type;

    @ApiModelProperty("商户门面图片地址")
    private String facadeUrl;

    @ApiModelProperty("商户营业执照图片地址")
    private String licenseUrl;

    @ApiModelProperty("商户联系人")
    private String contractor;

    @ApiModelProperty("商户联系电话")
    private String phone;

    @ApiModelProperty("所在省份编码")
    private String provinceCode;

    @ApiModelProperty("所在市级编码")
    private String cityCode;

    @ApiModelProperty("所在区县编码")
    private String countyCode;

    @ApiModelProperty("所在街道、城镇编码")
    private String townCode;

    @ApiModelProperty("详细地址")
    private String detailAddress;

    @ApiModelProperty("商户状态,0：待审核，1：审核通过，2：审核退回")
    private int status;

    @ApiModelProperty("商户对应业务系统中的用户ID，如果是app内提交的商户申请则有此信息")
    private long userId;

    @ApiModelProperty("商家介绍")
    private String description;

    @ApiModelProperty("商家头像")
    private String headImg;

    @ApiModelProperty("商家客服电话")
    private String servicePhone;

    @ApiModelProperty("所属商圈")
    private String businessArea;

    @ApiModelProperty("开始营业时间")
    private String businessStartTime;

    @ApiModelProperty("结束营业时间")
    private String businessEndTime;

    @ApiModelProperty(value = "商户地理位置纬度信息,如果不传递将根据商家详情位置进行定位")
    private Double lat;

    @ApiModelProperty(value = "商户地理位置经度信息,如果不传递将根据商家详情位置进行定位")
    private Double lng;

    public Double getLat() {
        return lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLng() {
        return lng;
    }

    public void setLng(Double lng) {
        this.lng = lng;
    }

    public String getBusinessArea() {
        return businessArea;
    }

    public void setBusinessArea(String businessArea) {
        this.businessArea = businessArea;
    }

    public String getBusinessStartTime() {
        return businessStartTime;
    }

    public void setBusinessStartTime(String businessStartTime) {
        this.businessStartTime = businessStartTime;
    }

    public String getBusinessEndTime() {
        return businessEndTime;
    }

    public void setBusinessEndTime(String businessEndTime) {
        this.businessEndTime = businessEndTime;
    }

    public String getServicePhone() {
        return servicePhone;
    }

    public void setServicePhone(String servicePhone) {
        this.servicePhone = servicePhone;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFacadeUrl() {
        return facadeUrl;
    }

    public void setFacadeUrl(String facadeUrl) {
        this.facadeUrl = facadeUrl;
    }

    public String getLicenseUrl() {
        return licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getContractor() {
        return contractor;
    }

    public void setContractor(String contractor) {
        this.contractor = contractor;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCountyCode() {
        return countyCode;
    }

    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    public String getTownCode() {
        return townCode;
    }

    public void setTownCode(String townCode) {
        this.townCode = townCode;
    }

    public String getDetailAddress() {
        return detailAddress;
    }

    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

}
