package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 地区信息关联信息
 *
 * @author liujia
 */
@ApiModel(description = "地区关联信息")
@Data
public class LocationRelationBean extends BaseBean {
    @ApiModelProperty("关联信息ID")
    private Long id;

    @ApiModelProperty(value = "地区编码", hidden = true)
    @JsonIgnore
    private String locationCode;

    @ApiModelProperty(value = "关联信息内容（如微信话术、朋友圈话术等）")
    private String content;

    @ApiModelProperty(value = "关联信息类型，1：微信分享话术，2：朋友圈话术，3：微信图片分享，4：朋友圈图片分享",
            allowableValues = "1,2,3,4,5,6,7,8", hidden = true)
    private Byte type;

    @ApiModelProperty(value = "创建时间", hidden = true)
    @JsonIgnore
    private Date createTime;

    @ApiModelProperty(value = "关联类型为3、4、7、8时，需要额外提供对应的图片地址")
    private String imageUrl;

    public LocationRelationBean() {
    }

    public LocationRelationBean(Long id, String content) {
        this.id = id;
        this.content = content;
    }
}
