package com.bxm.localnews.admin.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
@ApiModel(description = "混合推荐池")
public class MixedRecommendPool {
    @ApiModelProperty("新闻或帖子id")
    private Long id;

    @ApiModelProperty("新闻或帖子标题")
    private String title;

    @ApiModelProperty("新闻或帖子投放地区")
    private String areaDetail;

    @ApiModelProperty("权重")
    private Integer weight;

    @ApiModelProperty("来源 1：社区帖子 2：本地新闻 3：全国新闻")
    private String origin;

    @ApiModelProperty("展示时间")
    private Date issueTime;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("修改时间")
    private Date modifyTime;

    @ApiModelProperty("是否置顶 1：否 2：是")
    private Byte top;

    @ApiModelProperty("置顶生效时间")
    private Date topEffectiveTime;

    @ApiModelProperty("置顶失效时间")
    private Date topExpireTime;

    @ApiModelProperty("状态 0：失效 1：可用   ")
    private Byte status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getAreaDetail() {
        return areaDetail;
    }

    public void setAreaDetail(String areaDetail) {
        this.areaDetail = areaDetail == null ? null : areaDetail.trim();
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin == null ? null : origin.trim();
    }

    public Date getIssueTime() {
        return issueTime;
    }

    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Byte getTop() {
        return top;
    }

    public void setTop(Byte top) {
        this.top = top;
    }

    public Date getTopEffectiveTime() {
        return topEffectiveTime;
    }

    public void setTopEffectiveTime(Date topEffectiveTime) {
        this.topEffectiveTime = topEffectiveTime;
    }

    public Date getTopExpireTime() {
        return topExpireTime;
    }

    public void setTopExpireTime(Date topExpireTime) {
        this.topExpireTime = topExpireTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }
}