package com.bxm.localnews.admin.vo;

import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel(description = "投放区域信息")
public class PrivilegeAreaBean extends BaseBean implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "投放区域ID", hidden = true)
    @JsonIgnore
    private Long id;

    @ApiModelProperty(value = "所属活动ID", hidden = true)
    @JsonIgnore
    private Long privilegeId;

    @ApiModelProperty("投放区域编码")
    private String areaCode;

    @ApiModelProperty("投放区域名称")
    private String areaName;

    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPrivilegeId() {
        return privilegeId;
    }

    public void setPrivilegeId(Long privilegeId) {
        this.privilegeId = privilegeId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode == null ? null : areaCode.trim();
    }

}