package com.bxm.localnews.admin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "广告素材DTO")
public class AdvertMaterialDTO {


    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("素材名称")
    private String materialName;

    @ApiModelProperty("素材类型,1-文字，2-图片 3-任务素材")
    private Integer materialType;

    @ApiModelProperty("文字素材内容")
    private String materialContent;


    @ApiModelProperty("图片高度")
    private String imgHeight;


    @ApiModelProperty("图片宽度")
    private String imgWidth;


    @ApiModelProperty("图片地址")
    private String imgUrl;



    @ApiModelProperty("跳转地址")
    private String address;

    @ApiModelProperty("素材状态，0-停用，1-启用状态")
    private Integer materialStatus;

    @ApiModelProperty("文案")
    private String copy;

    @ApiModelProperty("任务主标题")
    private String taskMaintitle;

    @ApiModelProperty("任务副标题")
    private String taskSubtitle;

    @ApiModelProperty("按钮地址")
    private String iconUrl;

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public Integer getMaterialType() {
        return materialType;
    }

    public void setMaterialType(Integer materialType) {
        this.materialType = materialType;
    }

    public String getMaterialContent() {
        return materialContent;
    }

    public void setMaterialContent(String materialContent) {
        this.materialContent = materialContent;
    }

    public String getImgHeight() {
        return imgHeight;
    }

    public void setImgHeight(String imgHeight) {
        this.imgHeight = imgHeight;
    }

    public String getImgWidth() {
        return imgWidth;
    }

    public void setImgWidth(String imgWidth) {
        this.imgWidth = imgWidth;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getMaterialStatus() {
        return materialStatus;
    }

    public void setMaterialStatus(Integer materialStatus) {

        this.materialStatus = materialStatus;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCopy() {
        return copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public String getTaskMaintitle() {
        return taskMaintitle;
    }

    public void setTaskMaintitle(String taskMaintitle) {
        this.taskMaintitle = taskMaintitle;
    }

    public String getTaskSubtitle() {
        return taskSubtitle;
    }

    public void setTaskSubtitle(String taskSubtitle) {
        this.taskSubtitle = taskSubtitle;
    }

    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }
}
