package com.bxm.localnews.admin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/1/17 19:27
 * @desc
 */
@ApiModel(description = "推送消息统计")
public class PushMessageStatistical {

    @ApiModelProperty(value = "消息id")
    private Long id;

    @ApiModelProperty(value = "推送平台")
    private String pushPlatform;

    @ApiModelProperty(value = "平台推送量")
    private Long userTotal = 0L;

    @ApiModelProperty(value = "推送成功人数")
    private Long pushSuccess = 0L;

    @ApiModelProperty(value = "打开人数")
    private Long openTotal = 0L;

    @ApiModelProperty(value = "ios打开人数")
    private Long iosOpenNum = 0L;

    @ApiModelProperty(value = "android打开人数")
    private Long androidOpenNum = 0L;

    @ApiModelProperty(value = "打开率")
    private Double openRate = 0d;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPushPlatform() {
        return pushPlatform;
    }

    public void setPushPlatform(String pushPlatform) {
        this.pushPlatform = pushPlatform;
    }

    public Long getUserTotal() {
        return userTotal;
    }

    public void setUserTotal(Long userTotal) {
        this.userTotal = userTotal;
    }

    public Long getPushSuccess() {
        return pushSuccess;
    }

    public void setPushSuccess(Long pushSuccess) {
        this.pushSuccess = pushSuccess;
    }

    public Long getOpenTotal() {
        return openTotal;
    }

    public void setOpenTotal(Long openTotal) {
        this.openTotal = openTotal;
    }

    public Long getIosOpenNum() {
        return iosOpenNum;
    }

    public void setIosOpenNum(Long iosOpenNum) {
        this.iosOpenNum = iosOpenNum;
    }

    public Long getAndroidOpenNum() {
        return androidOpenNum;
    }

    public void setAndroidOpenNum(Long androidOpenNum) {
        this.androidOpenNum = androidOpenNum;
    }

    public Double getOpenRate() {
        return openRate;
    }

    public void setOpenRate(Double openRate) {
        this.openRate = openRate;
    }
}
