package com.bxm.localnews.admin.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author 
 */
@Data
@ApiModel("限制用户请求参数")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserBlockDTO implements Serializable {

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id", required = true)
    private Long userId;

    @ApiModelProperty(value = "禁止私聊,true-禁止,false-不禁止")
    private Boolean chatLimitFlag;

    @ApiModelProperty(value = "拉黑,true-拉黑,false-不拉黑")
    private Boolean blockFlag;

    @ApiModelProperty(value = "推荐降权,true-降权,false-不降权")
    private Boolean recommendLimitFlag;

    @ApiModelProperty(value = "限制时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date blockTime;


    private static final long serialVersionUID = 1L;


}