package com.bxm.localnews.admin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

@ApiModel(description = "聊天室记录查询参数")
@Data
public class ChatRoomQueryParam extends ImMessageQueryParam {

	@ApiModelProperty("地区编码")
	private String  areaCode;

	@ApiModelProperty("分页查询参数，当前是第几页,min[1]")
	private Integer pageNum = 1;
	@ApiModelProperty("分页查询参数，每页显示数量,默认为10,rang[1,200]")
	@Range(
			min = 0L,
			max = 200L
	)
	private Integer pageSize = 10;
}
