package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@ApiModel(description = "用户反馈参数")
public class FeedbackParam extends PageParam {

	@ApiModelProperty("反馈开始时间")
	@DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
	private Date startTime;

	@ApiModelProperty("反馈结束时间")
	@DateTimeFormat(pattern = DateUtils.DATE_TIME_FORMAT)
	private Date endTime;

	@ApiModelProperty("反馈用户id")
	private Long userId;

	@ApiModelProperty("反馈昵称")
	private String userNickName;

	@ApiModelProperty("反馈手机号")
	private String phone;

	@ApiModelProperty("反馈内容")
	private String keyWord;

}
