package com.bxm.localnews.admin.param;

import com.bxm.newidea.component.vo.PageParam;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/1/16 15:31
 * @desc
 */
@ApiModel(description = "消息推送记录")
public class PushMessageParam extends PageParam {

    @ApiModelProperty(value = "推送标题")
    private String title;

    @ApiModelProperty(value = "推送状态（0:待确认、1:待推送、2：已推送）")
    private Byte status;

    @ApiModelProperty(value = "推送目标：1、用户，2：区域")
    private Byte pushTarget;

    @ApiModelProperty(value = "创建人（运营账号id）")
    private Long createUserid;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "选择区域")
    private String areaCode;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public Byte getPushTarget() {
        return pushTarget;
    }

    public void setPushTarget(Byte pushTarget) {
        this.pushTarget = pushTarget;
    }

    public Long getCreateUserid() {
        return createUserid;
    }

    public void setCreateUserid(Long createUserid) {
        this.createUserid = createUserid;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
}
