package com.bxm.localnews.admin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("用户冗余信息修改参数实体")
public class UserSyncParam {

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID")
    private Long id;

    @ApiModelProperty("用户昵称")
    private String nickname;

    @ApiModelProperty("用户头像路径")
    private String headImg;

    @ApiModelProperty("用户性别：0:未知; 1:男; 2:女")
    private Byte sex;

    public Long getId() {
        return id;
    }

    public UserSyncParam setId(Long id) {
        this.id = id;
        return this;
    }

    public String getNickname() {
        return nickname;
    }

    public UserSyncParam setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    public String getHeadImg() {
        return headImg;
    }

    public UserSyncParam setHeadImg(String headImg) {
        this.headImg = headImg;
        return this;
    }

    public Byte getSex() {
        return sex;
    }

    public UserSyncParam setSex(Byte sex) {
        this.sex = sex;
        return this;
    }
}
