package com.bxm.localnews.admin.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "小视频更新实体")
public class VideoUpdateParam {

    /**
     * 主键
     */
    @ApiModelProperty("id")
    private Long id;

    /**
     * 视频标题
     */
    @ApiModelProperty("标题")
    private String title;

    /**
     * 标签
     */
    @ApiModelProperty("标签")
    private String label;

    /**
     * 热门过期时间
     */
    @ApiModelProperty("热门过期时间")
    private String hotExpireTime;

    /**
     * 视频状态（0：无效，1：有效）
     */
    @ApiModelProperty("视频状态：0无效 1有效")
    private Byte status;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getHotExpireTime() {
        return hotExpireTime;
    }

    public void setHotExpireTime(String hotExpireTime) {
        this.hotExpireTime = hotExpireTime;
    }

    public Byte getStatus() {
        return status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }
}
