package com.bxm.localnews.admin.vo;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "广告")
public class Advert {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("code")
    private String code;

    @ApiModelProperty("广告名称")
    private String title;

    @ApiModelProperty("缩略图")
    private String imgUrl;

    @ApiModelProperty("广告类型 1：首页弹窗广告 2：个人中心随机广告  3：赚钱中心轮播广告 4：列表广告 " +
            "5：赚钱中心公告 6：首页悬浮广告 7:开屏广告")
    private String type;

    @ApiModelProperty("广告跳转地址")
    private String address;

    @ApiModelProperty("添加时间")
    private Date addTime;

    @ApiModelProperty("状态 1：上架 2：下架  3：删除")
    private Byte status;

    @ApiModelProperty("广告商")
    private String author;

    @ApiModelProperty("广告商图标")
    private String authorImg;

    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("发送类型0：立即发送1：定时发送")
    private Byte sendType;

    @ApiModelProperty("标签（多个之间用逗号隔开）")
    private String label;

    @ApiModelProperty("广告开始投放时间")
    private Date startTime;

    @ApiModelProperty("广告结束投放时间")
    private Date endTime;

    @ApiModelProperty("广告倒计时时间（广告倒计时结束后自动关闭）")
    private Byte timeout;

    @ApiModelProperty("是否全局通用（0：false，1：true")
    private Byte globalFlag;

    @ApiModelProperty("展示方式：0默认展示，1新用户展示一次，2所有用户只展示1次，3每天第一次打开App时展示")
    private Byte showType;

    @ApiModelProperty("任务主标题")
    private String taskMaintitle;

    @ApiModelProperty("任务副标题")
    private String taskSubtitle;

    @ApiModelProperty("文案")
    private String copy;

    @ApiModelProperty("顺序")
    private Long order;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getImgUrl() {
        return this.imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl == null ? null : imgUrl.trim();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address == null ? null : address.trim();
    }

    public Date getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Byte getStatus() {
        return this.status;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthorImg() {
        return this.authorImg;
    }

    public void setAuthorImg(String authorImg) {
        this.authorImg = authorImg;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Byte getSendType() {
        return this.sendType;
    }

    public void setSendType(Byte sendType) {
        this.sendType = sendType;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Byte getTimeout() {
        return timeout;
    }

    public void setTimeout(Byte timeout) {
        this.timeout = timeout;
    }

    public Byte getGlobalFlag() {
        return globalFlag;
    }

    public void setGlobalFlag(Byte globalFlag) {
        this.globalFlag = globalFlag;
    }

    public Byte getShowType() {
        return showType;
    }

    public void setShowType(Byte showType) {
        this.showType = showType;
    }

    public String getTaskMaintitle() {
        return taskMaintitle;
    }

    public void setTaskMaintitle(String taskMaintitle) {
        this.taskMaintitle = taskMaintitle;
    }

    public String getTaskSubtitle() {
        return taskSubtitle;
    }

    public void setTaskSubtitle(String taskSubtitle) {
        this.taskSubtitle = taskSubtitle;
    }

    public String getCopy() {
        return copy;
    }

    public void setCopy(String copy) {
        this.copy = copy;
    }

    public Long getOrder() {
        return order;
    }

    public void setOrder(Long order) {
        this.order = order;
    }
}